/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.builders.ItemBptBase;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.EntityPowerLaser;
import buildcraft.core.EntityRobot;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class TileBuilder
extends TileBuildCraft
implements IBuilderInventory,
IPowerReceptor,
IMachine {
    private final ur[] items = new ur[28];
    private BptBuilderBase bluePrintBuilder;
    @TileNetworkData
    public Box box = new Box();
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private LinkedList path;
    private LinkedList pathLasers;
    private EntityRobot builderRobot;
    public PathIterator currentPathIterator;
    private boolean done = true;

    public TileBuilder() {
        this.powerProvider.configure(10, 25, 25, 25, 25);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            return;
        }
        for (int x = this.l - 1; x <= this.l + 1; ++x) {
            block1: for (int y2 = this.m - 1; y2 <= this.m + 1; ++y2) {
                for (int z = this.n - 1; z <= this.n + 1; ++z) {
                    any tile = this.k.q(x, y2, z);
                    if (!(tile instanceof TilePathMarker)) continue;
                    this.path = ((TilePathMarker)tile).getPath();
                    for (BlockIndex b : this.path) {
                        this.k.e(b.i, b.j, b.k, 0);
                        BuildCraftBuilders.pathMarkerBlock.c(this.k, b.i, b.j, b.k, BuildCraftBuilders.pathMarkerBlock.cm, 0);
                    }
                    continue block1;
                }
            }
        }
        if (this.path != null && this.pathLasers == null) {
            ((BlockIndex)this.path.getFirst()).i = this.l;
            ((BlockIndex)this.path.getFirst()).j = this.m;
            ((BlockIndex)this.path.getFirst()).k = this.n;
            this.createLasersForPath();
        }
        this.iterateBpt();
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockIndex previous = null;
        for (BlockIndex b : this.path) {
            if (previous != null) {
                EntityPowerLaser laser = new EntityPowerLaser(this.k, new Position((double)previous.i + 0.5, (double)previous.j + 0.5, (double)previous.k + 0.5), new Position((double)b.i + 0.5, (double)b.j + 0.5, (double)b.k + 0.5));
                laser.setTexture(DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png");
                laser.show();
                this.k.d((lq)laser);
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BptBuilderBase instanciateBluePrint(int x, int y2, int z, ForgeDirection o) {
        BptBase bpt = BuildCraftBuilders.getBptRootIndex().getBluePrint(this.items[0].j());
        if (bpt == null) {
            return null;
        }
        bpt = bpt.clone();
        BptContext context = new BptContext(this.k, null, bpt.getBoxForPos(x, y2, z));
        if (o != ForgeDirection.EAST) {
            if (o == ForgeDirection.SOUTH) {
                bpt.rotateLeft(context);
            } else if (o == ForgeDirection.WEST) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            } else if (o == ForgeDirection.NORTH) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            }
        }
        if (this.items[0].b() instanceof ItemBptTemplate) {
            return new BptBuilderTemplate(bpt, this.k, x, y2, z);
        }
        if (this.items[0].b() instanceof ItemBptBluePrint) {
            return new BptBuilderBlueprint((BptBlueprint)bpt, this.k, x, y2, z);
        }
        return null;
    }

    @Override
    public void doWork() {
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            return;
        }
        if (this.done) {
            return;
        }
        if (this.builderRobot != null && !this.builderRobot.readyToBuild()) {
            return;
        }
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        this.iterateBpt();
    }

    public void iterateBpt() {
        if (this.items[0] == null || !(this.items[0].b() instanceof ItemBptBase)) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder = null;
            }
            if (this.builderRobot != null) {
                this.builderRobot.x();
                this.builderRobot = null;
            }
            if (this.box.isInitialized()) {
                this.box.deleteLasers();
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            return;
        }
        if (this.bluePrintBuilder == null || this.bluePrintBuilder.done) {
            if (this.path != null && this.path.size() > 1) {
                if (this.currentPathIterator == null) {
                    Iterator it = this.path.iterator();
                    BlockIndex start = (BlockIndex)it.next();
                    this.currentPathIterator = new PathIterator(start, it);
                }
                if (this.bluePrintBuilder != null && this.builderRobot != null) {
                    this.builderRobot.markEndOfBlueprint(this.bluePrintBuilder);
                }
                this.bluePrintBuilder = this.currentPathIterator.next();
                if (this.bluePrintBuilder != null) {
                    this.box.deleteLasers();
                    this.box.reset();
                }
                if (this.builderRobot != null) {
                    this.builderRobot.setBox(this.box);
                }
                if (this.bluePrintBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                if (this.currentPathIterator == null) {
                    this.done = true;
                }
            } else if (this.bluePrintBuilder != null && this.bluePrintBuilder.done) {
                if (this.builderRobot != null) {
                    this.builderRobot.markEndOfBlueprint(this.bluePrintBuilder);
                }
                this.done = true;
                this.bluePrintBuilder = null;
            } else {
                this.bluePrintBuilder = this.instanciateBluePrint(this.l, this.m, this.n, ForgeDirection.values()[this.k.h(this.l, this.m, this.n)].getOpposite());
                if (this.bluePrintBuilder != null) {
                    this.box.initialize(this.bluePrintBuilder);
                    this.box.createLasers(this.k, LaserKind.Stripes);
                }
            }
        }
    }

    public int k_() {
        return this.items.length;
    }

    public ur a(int i) {
        return this.items[i];
    }

    public ur a(int i, int j) {
        ur result;
        if (this.items[i] == null) {
            result = null;
        } else if (this.items[i].a > j) {
            result = this.items[i].a(j);
        } else {
            ur tmp = this.items[i];
            this.items[i] = null;
            result = tmp;
        }
        if (i == 0) {
            this.iterateBpt();
        }
        return result;
    }

    public void a(int i, ur itemstack) {
        this.items[i] = itemstack;
        if (i == 0) {
            this.iterateBpt();
            this.done = false;
        }
    }

    public ur a_(int slot) {
        if (this.items[slot] == null) {
            return null;
        }
        ur toReturn = this.items[slot];
        this.items[slot] = null;
        return toReturn;
    }

    public String b() {
        return "Builder";
    }

    public int c() {
        return 64;
    }

    public boolean a_(qx entityplayer) {
        return this.k.q(this.l, this.m, this.n) == this;
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.items);
        if (nbttagcompound.b("box")) {
            this.box.initialize(nbttagcompound.l("box"));
        }
        if (nbttagcompound.b("path")) {
            this.path = new LinkedList();
            by list = nbttagcompound.m("path");
            for (int i = 0; i < list.c(); ++i) {
                this.path.add(new BlockIndex((bq)list.b(i)));
            }
        }
        this.done = nbttagcompound.n("done");
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.items);
        if (this.box.isInitialized()) {
            bq boxStore = new bq();
            this.box.writeToNBT(boxStore);
            nbttagcompound.a("box", (cd)boxStore);
        }
        if (this.path != null) {
            by list = new by();
            for (BlockIndex i : this.path) {
                bq c = new bq();
                i.writeTo(c);
                list.a((cd)c);
            }
            nbttagcompound.a("path", (cd)list);
        }
        nbttagcompound.a("done", this.done);
    }

    @Override
    public void w_() {
        super.w_();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box.isInitialized()) {
            this.box.deleteLasers();
        }
        if (this.builderRobot != null) {
            this.builderRobot.x();
            this.builderRobot = null;
        }
        this.cleanPathLasers();
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.k, LaserKind.Stripes);
        }
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public int powerRequest() {
        if (!(this.bluePrintBuilder == null && this.currentPathIterator == null || this.done)) {
            return this.powerProvider.getMaxEnergyReceived();
        }
        return 0;
    }

    @Override
    public void g() {
        super.g();
        if ((this.bluePrintBuilder == null || this.bluePrintBuilder.done) && this.box.isInitialized() && (this.builderRobot == null || this.builderRobot.done())) {
            this.box.deleteLasers();
            this.box.reset();
            if (CoreProxy.proxy.isSimulating(this.k)) {
                this.sendNetworkUpdate();
            }
            return;
        }
        if (!this.box.isInitialized() && this.bluePrintBuilder == null && this.builderRobot != null) {
            this.builderRobot.x();
            this.builderRobot = null;
        }
    }

    @Override
    public boolean isActive() {
        return !this.done;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void cleanPathLasers() {
        if (this.pathLasers != null) {
            for (EntityLaser laser : this.pathLasers) {
                laser.x();
            }
            this.pathLasers = null;
        }
    }

    public boolean isBuildingBlueprint() {
        return this.a(0) != null && this.a(0).b() instanceof ItemBptBluePrint;
    }

    public Collection getNeededItems() {
        if (this.bluePrintBuilder instanceof BptBuilderBlueprint) {
            return ((BptBuilderBlueprint)this.bluePrintBuilder).neededItems;
        }
        return null;
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return i != 0;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    private class PathIterator {
        public Iterator currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockIndex to;
        public double lastDistance;
        aoe oldBoundingBox = null;
        ForgeDirection o = null;

        public PathIterator(BlockIndex from, Iterator it) {
            this.to = (BlockIndex)it.next();
            this.currentIterator = it;
            double dx = this.to.i - from.i;
            double dy = this.to.j - from.j;
            double dz = this.to.k - from.k;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.i;
            this.iy = from.j;
            this.iz = from.k;
            this.lastDistance = (this.ix - (float)this.to.i) * (this.ix - (float)this.to.i) + (this.iy - (float)this.to.j) * (this.iy - (float)this.to.j) + (this.iz - (float)this.to.k) * (this.iz - (float)this.to.k);
            this.o = Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST) : (dz > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH);
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrint(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz), this.o)) != null) {
                aoe boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    if (bpt != null) {
                        return bpt;
                    }
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.i) * (this.ix - (float)this.to.i) + (this.iy - (float)this.to.j) * (this.iy - (float)this.to.j) + (this.iz - (float)this.to.k) * (this.iz - (float)this.to.k);
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(aoe left, aoe right) {
            if (left.d < right.a || left.a > right.d) {
                return false;
            }
            if (left.e < right.b || left.b > right.e) {
                return false;
            }
            return !(left.f < right.c) && !(left.c > right.f);
        }
    }
}

