/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.Trigger;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.power.PowerProvider;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.Engine;
import buildcraft.energy.EngineIron;
import buildcraft.energy.EngineStone;
import buildcraft.energy.EngineWood;
import buildcraft.energy.IEngineProvider;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEngine
extends TileBuildCraft
implements IPowerReceptor,
la,
ITankContainer,
IEngineProvider,
IOverrideDefaultTriggers,
IPipeConnection,
IBuilderInventory {
    @TileNetworkData
    public Engine engine;
    @TileNetworkData
    public int progressPart = 0;
    @TileNetworkData
    public float serverPistonSpeed = 0.0f;
    @TileNetworkData
    public boolean isActive = false;
    boolean lastPower = false;
    public int orientation;
    IPowerProvider provider = PowerFramework.currentFramework.createPowerProvider();
    public boolean isRedstonePowered = false;

    @Override
    public void initialize() {
        if (!CoreProxy.proxy.isRenderWorld(this.k)) {
            if (this.engine == null) {
                this.createEngineIfNeeded();
            }
            this.engine.orientation = ForgeDirection.VALID_DIRECTIONS[this.orientation];
            this.provider.configure(0, this.engine.minEnergyReceived(), this.engine.maxEnergyReceived(), 1, this.engine.maxEnergy);
            this.checkRedstonePower();
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.engine == null) {
            return;
        }
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            if (this.progressPart != 0) {
                this.engine.progress += this.serverPistonSpeed;
                if (this.engine.progress > 1.0f) {
                    this.progressPart = 0;
                    this.engine.progress = 0.0f;
                }
            } else if (this.isActive) {
                this.progressPart = 1;
            }
            return;
        }
        this.engine.update();
        float newPistonSpeed = this.engine.getPistonSpeed();
        if (newPistonSpeed != this.serverPistonSpeed) {
            this.serverPistonSpeed = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.progressPart != 0) {
            this.engine.progress += this.engine.getPistonSpeed();
            if ((double)this.engine.progress > 0.5 && this.progressPart == 1) {
                IPowerProvider receptor;
                float extracted;
                this.progressPart = 2;
                Position pos = new Position(this.l, this.m, this.n, this.engine.orientation);
                pos.moveForwards(1.0);
                any tile = this.k.q((int)pos.x, (int)pos.y, (int)pos.z);
                if (this.isPoweredTile(tile) && (extracted = this.engine.extractEnergy((receptor = ((IPowerReceptor)tile).getPowerProvider()).getMinEnergyReceived(), receptor.getMaxEnergyReceived(), true)) > 0.0f) {
                    receptor.receiveEnergy(extracted, this.engine.orientation.getOpposite());
                }
            } else if (this.engine.progress >= 1.0f) {
                this.engine.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.engine.isActive()) {
            Position pos = new Position(this.l, this.m, this.n, this.engine.orientation);
            pos.moveForwards(1.0);
            any tile = this.k.q((int)pos.x, (int)pos.y, (int)pos.z);
            if (this.isPoweredTile(tile)) {
                IPowerProvider receptor = ((IPowerReceptor)tile).getPowerProvider();
                if (this.engine.extractEnergy(receptor.getMinEnergyReceived(), receptor.getMaxEnergyReceived(), false) > 0.0f) {
                    this.progressPart = 1;
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.engine.burn();
    }

    private void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        this.sendNetworkUpdate();
    }

    private void createEngineIfNeeded() {
        if (this.engine == null) {
            int kind = this.k.h(this.l, this.m, this.n);
            this.engine = this.newEngine(kind);
            this.engine.orientation = ForgeDirection.VALID_DIRECTIONS[this.orientation];
            this.k.f(this.l, this.m, this.n, BuildCraftEnergy.engineBlock.cm);
        }
    }

    public void switchOrientation() {
        for (int i = this.orientation + 1; i <= this.orientation + 6; ++i) {
            ForgeDirection o = ForgeDirection.values()[i % 6];
            Position pos = new Position(this.l, this.m, this.n, o);
            pos.moveForwards(1.0);
            any tile = this.k.q((int)pos.x, (int)pos.y, (int)pos.z);
            if (!this.isPoweredTile(tile)) continue;
            if (this.engine != null) {
                this.engine.orientation = o;
            }
            this.orientation = o.ordinal();
            this.k.i(this.l, this.m, this.n);
            this.k.h(this.l, this.m, this.n, this.k.a(this.l, this.m, this.n));
            break;
        }
    }

    public void delete() {
        if (this.engine != null) {
            this.engine.delete();
        }
    }

    public Engine newEngine(int meta) {
        if (meta == 0) {
            return new EngineWood(this);
        }
        if (meta == 1) {
            return new EngineStone(this);
        }
        if (meta == 2) {
            return new EngineIron(this);
        }
        return null;
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        int kind = nbttagcompound.e("kind");
        this.engine = this.newEngine(kind);
        this.orientation = nbttagcompound.e("orientation");
        if (this.engine != null) {
            this.engine.progress = nbttagcompound.g("progress");
            this.engine.energy = nbttagcompound.g("energyF");
            this.engine.orientation = ForgeDirection.values()[this.orientation];
        }
        if (this.engine != null) {
            this.engine.readFromNBT(nbttagcompound);
        }
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("kind", this.k.h(this.l, this.m, this.n));
        if (this.engine != null) {
            nbttagcompound.a("orientation", this.orientation);
            nbttagcompound.a("progress", this.engine.progress);
            nbttagcompound.a("energyF", this.engine.energy);
        }
        if (this.engine != null) {
            this.engine.writeToNBT(nbttagcompound);
        }
    }

    public int k_() {
        if (this.engine != null) {
            return this.engine.getSizeInventory();
        }
        return 0;
    }

    public ur a(int i) {
        if (this.engine != null) {
            return this.engine.getStackInSlot(i);
        }
        return null;
    }

    public ur a(int i, int j) {
        if (this.engine != null) {
            return this.engine.decrStackSize(i, j);
        }
        return null;
    }

    public ur a_(int i) {
        if (this.engine != null) {
            return this.engine.getStackInSlotOnClosing(i);
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        if (this.engine != null) {
            this.engine.setInventorySlotContents(i, itemstack);
        }
    }

    public String b() {
        return "Engine";
    }

    public int c() {
        return 64;
    }

    public boolean a_(qx entityplayer) {
        return this.k.q(this.l, this.m, this.n) == this;
    }

    public boolean isBurning() {
        return this.engine != null && this.engine.isBurning();
    }

    public int getScaledBurnTime(int i) {
        if (this.engine != null) {
            return this.engine.getScaledBurnTime(i);
        }
        return 0;
    }

    @Override
    public ef l() {
        this.createEngineIfNeeded();
        return super.l();
    }

    @Override
    public ef getUpdatePacket() {
        if (this.engine != null) {
            this.serverPistonSpeed = this.engine.getPistonSpeed();
        }
        return super.getUpdatePacket();
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        this.createEngineIfNeeded();
        super.handleDescriptionPacket(packet);
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        this.createEngineIfNeeded();
        super.handleUpdatePacket(packet);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.provider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public void doWork() {
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            return;
        }
        this.engine.addEnergy(this.provider.useEnergy(1.0f, this.engine.maxEnergyReceived(), true) * 0.95f);
    }

    public boolean isPoweredTile(any tile) {
        if (tile instanceof IPowerReceptor) {
            IPowerProvider receptor = ((IPowerReceptor)tile).getPowerProvider();
            return receptor != null && receptor.getClass().getSuperclass().equals(PowerProvider.class);
        }
        return false;
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public int powerRequest() {
        return 0;
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public LinkedList getTriggers() {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        triggers.add(BuildCraftEnergy.triggerBlueEngineHeat);
        triggers.add(BuildCraftEnergy.triggerGreenEngineHeat);
        triggers.add(BuildCraftEnergy.triggerYellowEngineHeat);
        triggers.add(BuildCraftEnergy.triggerRedEngineHeat);
        if (this.engine instanceof EngineIron) {
            triggers.add(BuildCraftCore.triggerEmptyLiquid);
            triggers.add(BuildCraftCore.triggerContainsLiquid);
            triggers.add(BuildCraftCore.triggerSpaceLiquid);
            triggers.add(BuildCraftCore.triggerFullLiquid);
        } else if (this.engine instanceof EngineStone) {
            triggers.add(BuildCraftCore.triggerEmptyInventory);
            triggers.add(BuildCraftCore.triggerContainsInventory);
            triggers.add(BuildCraftCore.triggerSpaceInventory);
            triggers.add(BuildCraftCore.triggerFullInventory);
        }
        return triggers;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        if (this.engine instanceof EngineWood) {
            return false;
        }
        return with.ordinal() != this.orientation;
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return false;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.k.B(this.l, this.m, this.n);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.fill(from, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidTank[] getTanks(ForgeDirection direction) {
        if (this.engine == null) {
            return new LiquidTank[0];
        }
        return this.engine.getLiquidSlots();
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.engine != null ? this.engine.getTank(direction, type) : null;
    }
}

