/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.core.DefaultProps;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;

public class TriggerEngineHeat
extends Trigger {
    public Engine.EnergyStage stage;

    public TriggerEngineHeat(int id, Engine.EnergyStage stage) {
        super(id);
        this.stage = stage;
    }

    @Override
    public int getIndexInTexture() {
        switch (this.stage) {
            case Blue: {
                return 16;
            }
            case Green: {
                return 17;
            }
            case Yellow: {
                return 18;
            }
        }
        return 19;
    }

    @Override
    public String getDescription() {
        switch (this.stage) {
            case Blue: {
                return "Engine Blue";
            }
            case Green: {
                return "Engine Green";
            }
            case Yellow: {
                return "Engine Yellow";
            }
        }
        return "Engine Red";
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (tile instanceof TileEngine) {
            Engine engine = ((TileEngine)tile).engine;
            return engine != null && engine.getEnergyStage() == this.stage;
        }
        return false;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }
}

