/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.ILaserTarget;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class TileLaser
extends TileBuildCraft
implements IPowerReceptor {
    private EntityEnergyLaser laser = null;
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker();
    private final SafeTimeTracker searchTracker = new SafeTimeTracker();
    private final SafeTimeTracker networkTracker = new SafeTimeTracker();
    private ILaserTarget laserTarget;
    public IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private int nextNetworkUpdate = 3;
    private int nextLaserUpdate = 10;
    private int nextLaserSearch = 10;

    public TileLaser() {
        this.powerProvider.configure(20, 25, 25, 25, 1000);
    }

    @Override
    public void g() {
        if (!CoreProxy.proxy.isSimulating(this.k)) {
            return;
        }
        if (this.powerProvider.getEnergyStored() == 0.0f) {
            this.removeLaser();
            return;
        }
        if (!this.isValidTable() && this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.laser == null) {
            this.createLaser();
        }
        if (this.laser != null && this.canUpdateLaser()) {
            this.updateLaser();
        }
        float power = this.powerProvider.useEnergy(0.0f, 4.0f, true);
        this.laserTarget.receiveLaserEnergy(power);
        if (this.laser != null) {
            this.laser.pushPower(power);
        }
        this.sendNetworkUpdate();
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.k, this.nextLaserSearch);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.k, this.nextLaserUpdate);
    }

    protected boolean isValidTable() {
        return this.laserTarget != null && !this.laserTarget.r() && this.laserTarget.hasCurrentWork();
    }

    protected void findTable() {
        int meta = this.k.h(this.l, this.m, this.n);
        int minX = this.l - 5;
        int minY = this.m - 5;
        int minZ = this.n - 5;
        int maxX = this.l + 5;
        int maxY = this.m + 5;
        int maxZ = this.n + 5;
        switch (ForgeDirection.values()[meta]) {
            case WEST: {
                maxX = this.l;
                break;
            }
            case EAST: {
                minX = this.l;
                break;
            }
            case DOWN: {
                maxY = this.m;
                break;
            }
            case UP: {
                minY = this.m;
                break;
            }
            case NORTH: {
                maxZ = this.n;
                break;
            }
            default: {
                minZ = this.n;
            }
        }
        LinkedList<BlockIndex> targets = new LinkedList<BlockIndex>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ILaserTarget table;
                    any tile = this.k.q(x, y2, z);
                    if (!(tile instanceof ILaserTarget) || !(table = (ILaserTarget)tile).hasCurrentWork()) continue;
                    targets.add(new BlockIndex(x, y2, z));
                }
            }
        }
        if (targets.size() == 0) {
            return;
        }
        BlockIndex b = (BlockIndex)targets.get(this.k.t.nextInt(targets.size()));
        this.laserTarget = (ILaserTarget)this.k.q(b.i, b.j, b.k);
    }

    protected void createLaser() {
        this.laser = new EntityEnergyLaser(this.k, new Position(this.l, this.m, this.n), new Position(this.l, this.m, this.n));
        this.k.d((lq)this.laser);
    }

    protected void updateLaser() {
        int meta = this.k.h(this.l, this.m, this.n);
        double px2 = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (ForgeDirection.values()[meta]) {
            case WEST: {
                px2 = -0.3;
                break;
            }
            case EAST: {
                px2 = 0.3;
                break;
            }
            case DOWN: {
                py = -0.3;
                break;
            }
            case UP: {
                py = 0.3;
                break;
            }
            case NORTH: {
                pz = -0.3;
                break;
            }
            default: {
                pz = 0.3;
            }
        }
        Position head = new Position((double)this.l + 0.5 + px2, (double)this.m + 0.5 + py, (double)this.n + 0.5 + pz);
        Position tail = new Position((double)this.laserTarget.getXCoord() + 0.475 + ((double)this.k.t.nextFloat() - 0.5) / 5.0, (float)this.laserTarget.getYCoord() + 0.5625f, (double)this.laserTarget.getZCoord() + 0.475 + ((double)this.k.t.nextFloat() - 0.5) / 5.0);
        this.laser.setPositions(head, tail);
        if (!this.laser.isVisible()) {
            this.laser.show();
        }
    }

    protected void removeLaser() {
        if (this.laser != null) {
            this.laser.x();
            this.laser = null;
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest() {
        if (this.powerProvider.getEnergyStored() < 200.0f || this.laser != null) {
            return 25;
        }
        return 0;
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.k, this.nextNetworkUpdate)) {
            super.sendNetworkUpdate();
        }
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 25, 25, 25, 1000);
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
    }

    @Override
    public void w_() {
        super.w_();
        this.removeLaser();
    }
}

