/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.StringUtil;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import java.util.Iterator;
import java.util.LinkedList;
import org.lwjgl.opengl.GL11;

public class GuiAssemblyTable
extends GuiAdvancedInterface {
    TileAssemblyTable assemblyTable;

    public GuiAssemblyTable(la playerInventory, TileAssemblyTable assemblyTable) {
        super(new ContainerAssemblyTable(playerInventory, assemblyTable), assemblyTable);
        this.assemblyTable = assemblyTable;
        this.b = 175;
        this.c = 207;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[8];
        int p = 0;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.slots[p] = new RecipeSlot(134 + 18 * j, 36 + 18 * i);
                ++p;
            }
        }
        this.updateRecipes();
        if (CoreProxy.proxy.isRenderWorld(assemblyTable.k)) {
            CoreProxy.proxy.sendToServer(new PacketCoordinates(20, assemblyTable.l, assemblyTable.m, assemblyTable.n).getPacket());
        }
    }

    public void updateRecipes() {
        LinkedList potentialRecipes = this.assemblyTable.getPotentialOutputs();
        Iterator cur = potentialRecipes.iterator();
        for (int p = 0; p < 8; ++p) {
            ((RecipeSlot)this.slots[p]).recipe = cur.hasNext() ? (AssemblyRecipe)cur.next() : null;
        }
    }

    @Override
    protected void b(int par1, int par2) {
        super.b(par1, par2);
        String title = StringUtil.localize("tile.assemblyTableBlock");
        this.l.b(title, this.getCenteredOffset(title), 15, 0x404040);
        this.l.b(StringUtil.localize("gui.inventory"), 8, this.c - 97, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    protected void a(float f, int x, int y2) {
        int i = this.f.o.b(DefaultProps.TEXTURE_PATH_GUI + "/assembly_table.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f.o.b(i);
        int cornerX = (this.g - this.b) / 2;
        int cornerY = (this.h - this.c) / 2;
        this.b(cornerX, cornerY, 0, 0, this.b, this.c);
        this.updateRecipes();
        for (int s2 = 0; s2 < this.slots.length; ++s2) {
            RecipeSlot slot = (RecipeSlot)this.slots[s2];
            if (this.assemblyTable.isAssembling(slot.recipe)) {
                this.b(cornerX + slot.x, cornerY + slot.y, 196, 1, 16, 16);
                continue;
            }
            if (!this.assemblyTable.isPlanned(slot.recipe)) continue;
            this.b(cornerX + slot.x, cornerY + slot.y, 177, 1, 16, 16);
        }
        int height = (int)this.assemblyTable.getCompletionRatio(70.0f);
        this.b(cornerX + 95, cornerY + 36 + 70 - height, 176, 18, 4, height);
        this.drawBackgroundSlots();
    }

    @Override
    protected void a(int i, int j, int k) {
        super.a(i, j, k);
        int cornerX = (this.g - this.b) / 2;
        int cornerY = (this.h - this.c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        if (position != -1) {
            RecipeSlot slot = (RecipeSlot)this.slots[position];
            if (slot.recipe == null) {
                return;
            }
            TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
            if (this.assemblyTable.isPlanned(slot.recipe)) {
                this.assemblyTable.cancelPlanOutput(slot.recipe);
                message.select = false;
            } else {
                this.assemblyTable.planOutput(slot.recipe);
                message.select = true;
            }
            message.itemID = slot.recipe.output.c;
            message.itemDmg = slot.recipe.output.j();
            if (CoreProxy.proxy.isRenderWorld(this.assemblyTable.k)) {
                PacketPayload payload = TileAssemblyTable.selectionMessageWrapper.toPayload(this.assemblyTable.l, this.assemblyTable.m, this.assemblyTable.n, message);
                PacketUpdate packet = new PacketUpdate(21, payload);
                packet.posX = this.assemblyTable.l;
                packet.posY = this.assemblyTable.m;
                packet.posZ = this.assemblyTable.n;
                CoreProxy.proxy.sendToServer(packet.getPacket());
            }
        }
    }

    @Override
    protected void initLedgers(la inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new AssemblyLedger());
    }

    class RecipeSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        public AssemblyRecipe recipe;

        public RecipeSlot(int x, int y2) {
            super(x, y2);
        }

        @Override
        public ur getItemStack() {
            if (this.recipe != null) {
                return this.recipe.output;
            }
            return null;
        }
    }

    class AssemblyLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public AssemblyLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y2) {
            this.drawBackground(x, y2);
            this.drawIcon(DefaultProps.TEXTURE_ICONS, 0, x + 3, y2 + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiAssemblyTable.this.l.a(StringUtil.localize("gui.energy"), x + 22, y2 + 8, this.headerColour);
            GuiAssemblyTable.this.l.a(StringUtil.localize("gui.assemblyCurrentRequired") + ":", x + 22, y2 + 20, this.subheaderColour);
            GuiAssemblyTable.this.l.b(String.format("%2.1f MJ", Float.valueOf(GuiAssemblyTable.this.assemblyTable.getRequiredEnergy())), x + 22, y2 + 32, this.textColour);
            GuiAssemblyTable.this.l.a(StringUtil.localize("gui.stored") + ":", x + 22, y2 + 44, this.subheaderColour);
            GuiAssemblyTable.this.l.b(String.format("%2.1f MJ", Float.valueOf(GuiAssemblyTable.this.assemblyTable.getStoredEnergy())), x + 22, y2 + 56, this.textColour);
            GuiAssemblyTable.this.l.a(StringUtil.localize("gui.assemblyRate") + ":", x + 22, y2 + 68, this.subheaderColour);
            GuiAssemblyTable.this.l.b(String.format("%3.2f MJ/t", Float.valueOf((float)GuiAssemblyTable.this.assemblyTable.getRecentEnergyAverage() / 100.0f)), x + 22, y2 + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%3.2f MJ/t", Float.valueOf((float)GuiAssemblyTable.this.assemblyTable.getRecentEnergyAverage() / 100.0f));
        }
    }
}

