/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.Trigger;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.TileBuffer;
import buildcraft.core.network.IClientState;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.network.PipeRenderStatePacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileGenericPipe
extends any
implements IPowerReceptor,
ITankContainer,
IPipeEntry,
IPipeTile,
IOverrideDefaultTriggers,
ITileBufferHolder,
IPipeConnection,
IDropControlInventory,
IPipeRenderState,
ISyncedTile {
    private PipeRenderState renderState = new PipeRenderState();
    private CoreState coreState = new CoreState();
    public TileBuffer[] tileBuffer;
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public SafeTimeTracker networkSyncTracker = new SafeTimeTracker();
    public Pipe pipe;
    private boolean blockNeighborChange = false;
    private boolean refreshRenderState = false;
    private boolean pipeBound = false;
    private int[] facadeBlocks = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] facadeMeta = new int[ForgeDirection.VALID_DIRECTIONS.length];
    public boolean initialized = false;

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        if (this.pipe != null) {
            nbttagcompound.a("pipeId", this.pipe.itemID);
            this.pipe.writeToNBT(nbttagcompound);
        } else {
            nbttagcompound.a("pipeId", this.coreState.pipeId);
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            nbttagcompound.a("facadeBlocks[" + i + "]", this.facadeBlocks[i]);
            nbttagcompound.a("facadeMeta[" + i + "]", this.facadeMeta[i]);
        }
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.coreState.pipeId = nbttagcompound.e("pipeId");
        this.pipe = BlockGenericPipe.createPipe(this.coreState.pipeId);
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbttagcompound);
        } else {
            BuildCraftCore.bcLog.warning("Pipe failed to load from NBT at " + this.l + "," + this.m + "," + this.n);
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.facadeBlocks[i] = nbttagcompound.e("facadeBlocks[" + i + "]");
            this.facadeMeta[i] = nbttagcompound.e("facadeMeta[" + i + "]");
        }
    }

    public void w_() {
        this.initialized = false;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        super.w_();
    }

    public void s() {
        super.s();
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
    }

    public void g() {
        IPowerProvider provider;
        if (this.pipe == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize(this.pipe);
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
        if ((provider = this.getPowerProvider()) != null) {
            provider.update(this);
        }
        if (this.pipe != null) {
            this.pipe.updateEntity();
        }
    }

    private void refreshRenderState() {
        if (this.k.I) {
            return;
        }
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.pipeConnectionMatrix.setConnected(forgeDirection, this.pipeConnectionsBuffer[forgeDirection.ordinal()]);
        }
        this.renderState.setTextureFile(this.pipe.getTextureFile());
        for (ForgeDirection forgeDirection : ForgeDirection.values()) {
            this.renderState.textureMatrix.setTextureIndex(forgeDirection, this.pipe.getTextureIndex(forgeDirection));
        }
        for (IPipe.WireColor wireColor : IPipe.WireColor.values()) {
            this.renderState.wireMatrix.setWire(wireColor, this.pipe.wireSet[wireColor.ordinal()]);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.renderState.wireMatrix.setWireConnected(wireColor, direction, this.pipe.isWireConnectedTo(this.getTile(direction), wireColor));
            }
        }
        if (this.pipe.wireSet[IPipe.WireColor.Red.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Red, this.pipe.signalStrength[IPipe.WireColor.Red.ordinal()] > 0 ? 6 : 5);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Red, 0);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Blue.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Blue, this.pipe.signalStrength[IPipe.WireColor.Blue.ordinal()] > 0 ? 8 : 7);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Blue, 0);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Green.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Green, this.pipe.signalStrength[IPipe.WireColor.Green.ordinal()] > 0 ? 10 : 9);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Green, 0);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Yellow.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Yellow, this.pipe.signalStrength[IPipe.WireColor.Yellow.ordinal()] > 0 ? 12 : 11);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Yellow, 0);
        }
        this.renderState.setHasGate(this.pipe.hasGate());
        this.renderState.setGateTexture(!this.pipe.hasGate() ? 0 : this.pipe.gate.getTexture(this.pipe.isGateActive()));
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            int blockId = this.facadeBlocks[forgeDirection.ordinal()];
            this.renderState.facadeMatrix.setConnected(forgeDirection, blockId != 0 && amq.p[blockId] != null);
            if (amq.p[blockId] == null) continue;
            amq block = amq.p[blockId];
            this.renderState.facadeMatrix.setTextureFile(forgeDirection, block.getTextureFile());
            this.renderState.facadeMatrix.setTextureIndex(forgeDirection, block.a(forgeDirection.ordinal(), this.facadeMeta[forgeDirection.ordinal()]));
        }
        if (this.renderState.isDirty()) {
            this.k.i(this.l, this.m, this.n);
            this.renderState.clean();
        }
    }

    public void initialize(Pipe pipe) {
        this.pipe = pipe;
        this.tileBuffer = new TileBuffer[6];
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            Position pos = new Position(this.l, this.m, this.n, o);
            pos.moveForwards(1.0);
            this.tileBuffer[o.ordinal()] = new TileBuffer();
            this.tileBuffer[o.ordinal()].initialize(this.k, (int)pos.x, (int)pos.y, (int)pos.z);
        }
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            any tile = this.getTile(o);
            if (!(tile instanceof ITileBufferHolder)) continue;
            ((ITileBufferHolder)tile).blockCreated(o, BuildCraftTransport.genericPipeBlock.cm, this);
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleRenderUpdate();
        if (pipe != null) {
            pipe.initialize();
        } else {
            BuildCraftCore.bcLog.warning("Pipe failed to initialize pipe at " + this.l + "," + this.m + "," + this.n);
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = this.pipe.itemID;
            this.pipeBound = true;
        }
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).setPowerProvider(provider);
        }
    }

    @Override
    public IPowerProvider getPowerProvider() {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            return ((IPowerReceptor)((Object)this.pipe)).getPowerProvider();
        }
        return null;
    }

    @Override
    public void doWork() {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).doWork();
        }
    }

    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
    }

    @Override
    public void entityEntering(IPipedItem item, ForgeDirection orientation) {
        if (BlockGenericPipe.isValid(this.pipe)) {
            this.pipe.transport.entityEntering(item, orientation);
        }
    }

    @Override
    public void entityEntering(ur payload, ForgeDirection orientation) {
        Position itemPos = new Position(this.l, this.m, this.n, orientation);
        itemPos.moveBackwards(1.0);
        itemPos.x += 0.5;
        itemPos.y += 0.25;
        itemPos.z += 0.5;
        itemPos.moveForwards(0.5);
        EntityPassiveItem pipedItem = new EntityPassiveItem(this.k, itemPos.x, itemPos.y, itemPos.z, payload);
        this.entityEntering(pipedItem, orientation);
    }

    @Override
    public boolean acceptItems() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.transport.acceptItems();
        }
        return false;
    }

    public void handleDescriptionPacket(PipeRenderStatePacket packet) {
        if (this.k.I) {
            if (this.pipe == null && packet.getPipeId() != 0) {
                this.initialize(BlockGenericPipe.createPipe(packet.getPipeId()));
            }
            this.renderState = packet.getRenderState();
            this.k.o(this.l, this.m, this.n);
        }
    }

    public ef l() {
        this.bindPipe();
        PacketTileState packet = new PacketTileState(this.l, this.m, this.n);
        this.coreState.gateKind = this.pipe != null && this.pipe.gate != null ? this.pipe.gate.kind.ordinal() : 0;
        if (this.pipe != null && this.pipe.transport != null) {
            this.pipe.transport.sendDescriptionPacket();
        }
        packet.addStateForSerialization((byte)0, this.coreState);
        packet.addStateForSerialization((byte)1, this.renderState);
        if (this.pipe instanceof IClientState) {
            packet.addStateForSerialization((byte)2, (IClientState)((Object)this.pipe));
        }
        return packet.getPacket();
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public LinkedList getTriggers() {
        LinkedList<Trigger> result = new LinkedList<Trigger>();
        if (BlockGenericPipe.isFullyDefined(this.pipe) && this.pipe.hasGate()) {
            result.add(BuildCraftCore.triggerRedstoneActive);
            result.add(BuildCraftCore.triggerRedstoneInactive);
        }
        return result;
    }

    @Override
    public void blockRemoved(ForgeDirection from) {
    }

    @Override
    public void blockCreated(ForgeDirection from, int blockID, any tile) {
        if (this.tileBuffer != null) {
            this.tileBuffer[from.getOpposite().ordinal()].set(blockID, tile);
        }
    }

    @Override
    public int getBlockId(ForgeDirection to) {
        if (this.tileBuffer != null) {
            return this.tileBuffer[to.ordinal()].getBlockID();
        }
        return 0;
    }

    @Override
    public any getTile(ForgeDirection to) {
        if (this.tileBuffer != null) {
            return this.tileBuffer[to.ordinal()].getTile();
        }
        return null;
    }

    public boolean isPipeConnected(any with, ForgeDirection side) {
        Pipe pipe1 = this.pipe;
        Pipe pipe2 = null;
        if (with instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)with).pipe;
        }
        if (!BlockGenericPipe.isValid(pipe1)) {
            return false;
        }
        if (BlockGenericPipe.isValid(pipe2) && !pipe1.transport.getClass().isAssignableFrom(pipe2.transport.getClass()) && !pipe1.transport.allowsConnect(pipe2.transport)) {
            return false;
        }
        if (pipe2 != null && !pipe2.isPipeConnected(this, side)) {
            return false;
        }
        return pipe1 != null ? pipe1.isPipeConnected(with, side) : false;
    }

    private void computeConnections() {
        if (this.tileBuffer != null) {
            boolean[] oldConnections = this.pipeConnectionsBuffer;
            this.pipeConnectionsBuffer = new boolean[6];
            for (int i = 0; i < this.tileBuffer.length; ++i) {
                TileBuffer t = this.tileBuffer[i];
                t.refresh();
                if (t.getTile() == null) continue;
                this.pipeConnectionsBuffer[i] = this.isPipeConnected(t.getTile(), ForgeDirection.VALID_DIRECTIONS[i].getOpposite());
                if (!(t.getTile() instanceof TileGenericPipe)) continue;
                TileGenericPipe pipe = (TileGenericPipe)t.getTile();
                pipe.pipeConnectionsBuffer[ForgeDirection.VALID_DIRECTIONS[i].getOpposite().ordinal()] = this.pipeConnectionsBuffer[i];
            }
        }
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)this.pipe.transport).fill(tankIndex, resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)this.pipe.transport).drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)this.pipe.transport).getTanks(direction);
        }
        return null;
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean addFacade(ForgeDirection direction, int blockid, int meta) {
        if (this.k.I) {
            return false;
        }
        if (this.facadeBlocks[direction.ordinal()] == blockid) {
            return false;
        }
        if (this.hasFacade(direction)) {
            this.dropFacade(direction);
        }
        this.facadeBlocks[direction.ordinal()] = blockid;
        this.facadeMeta[direction.ordinal()] = meta;
        this.scheduleRenderUpdate();
        return true;
    }

    public boolean hasFacade(ForgeDirection direction) {
        if (this.k.I) {
            return this.renderState.facadeMatrix.isConnected(direction);
        }
        return this.facadeBlocks[direction.ordinal()] != 0;
    }

    public void dropFacade(ForgeDirection direction) {
        if (this.k.I) {
            return;
        }
        if (!this.hasFacade(direction)) {
            return;
        }
        Utils.dropItems(this.k, new ur(BuildCraftTransport.facadeItem, 1, ItemFacade.encode(this.facadeBlocks[direction.ordinal()], this.facadeMeta[direction.ordinal()])), this.l, this.m, this.n);
        this.facadeBlocks[direction.ordinal()] = 0;
        this.facadeMeta[direction.ordinal()] = 0;
        this.scheduleRenderUpdate();
    }

    @Override
    public PipeRenderState getRenderState() {
        return this.renderState;
    }

    @Override
    public IClientState getStateInstance(byte stateId) {
        switch (stateId) {
            case 0: {
                return this.coreState;
            }
            case 1: {
                return this.renderState;
            }
            case 2: {
                return (IClientState)((Object)this.pipe);
            }
        }
        throw new RuntimeException("Unknown state requested: " + stateId + " this is a bug!");
    }

    @Override
    public void afterStateUpdated(byte stateId) {
        if (!this.k.I) {
            return;
        }
        switch (stateId) {
            case 0: {
                if (this.pipe == null && this.coreState.pipeId != 0) {
                    this.initialize(BlockGenericPipe.createPipe(this.coreState.pipeId));
                }
                if (this.pipe == null || this.coreState.gateKind == Gate.GateKind.None.ordinal()) break;
                if (this.pipe.gate == null) {
                    this.pipe.gate = new GateVanilla(this.pipe);
                }
                this.pipe.gate.kind = Gate.GateKind.values()[this.coreState.gateKind];
            }
        }
        this.k.o(this.l, this.m, this.n);
    }

    @SideOnly(value=Side.CLIENT)
    public double m() {
        return DefaultProps.PIPE_CONTENTS_RENDER_DIST * DefaultProps.PIPE_CONTENTS_RENDER_DIST;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)this.pipe.transport).getTank(direction, type);
        }
        return null;
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, yc world, int x, int y2, int z) {
        return oldID != newID;
    }

    private class CoreState
    implements IClientState {
        public int pipeId = -1;
        public int gateKind = 0;

        private CoreState() {
        }

        @Override
        public void writeData(DataOutputStream data) throws IOException {
            data.writeInt(this.pipeId);
            data.writeInt(this.gateKind);
        }

        @Override
        public void readData(DataInputStream data) throws IOException {
            this.pipeId = data.readInt();
            this.gateKind = data.readInt();
        }
    }
}

