/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.core.ItemInterface;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import java.awt.Rectangle;
import java.util.List;
import mistaqur.nei.forestry.ForestryRecipeHandler;

public class PeatFuelHandler
extends ForestryRecipeHandler {
    static int ashForItem = 7500;

    public String getRecipeName() {
        return "Peat Fuel";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(40, 16, 14, 14), "forestry.peat.fuel", new Object[0]));
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 40, 16, 176, 0, 14, 14, 48, 7);
    }

    public List handleItemTooltip(GuiRecipe guiRecipe, ur stack, List currenttip, int recipe) {
        CachedPeatFuel cfuel = (CachedPeatFuel)((Object)this.arecipes.get(recipe));
        if (cfuel.fuelSlot != null && guiRecipe.isMouseOver(cfuel.fuelSlot, recipe)) {
            currenttip.add("\u00a77Output: " + cfuel.powerPerCycle + " MJ/t");
            currenttip.add("\u00a77Duration: " + cfuel.burnDuration + " t");
        }
        if (cfuel.ashSlot != null && guiRecipe.isMouseOver(cfuel.ashSlot, recipe)) {
            currenttip.add("\u00a77Items to produce: " + Float.toString(1.0f * (float)ashForItem / (float)cfuel.burnDuration));
        }
        return currenttip;
    }

    public void loadUsageRecipes(ur ingredient) {
        EngineCopperFuel fuel = (EngineCopperFuel)FuelManager.copperEngineFuel.get(ingredient);
        if (fuel != null) {
            this.arecipes.add(new CachedPeatFuel(fuel));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.peat.fuel") && ((Object)((Object)this)).getClass() == PeatFuelHandler.class) {
            for (EngineCopperFuel fuel : FuelManager.copperEngineFuel.values()) {
                this.arecipes.add(new CachedPeatFuel(fuel));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/peatengine.png";
    }

    public class CachedPeatFuel
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack fuelSlot;
        PositionedStack ashSlot;
        int powerPerCycle;
        int burnDuration;

        public CachedPeatFuel(EngineCopperFuel fuel) {
            super((TemplateRecipeHandler)PeatFuelHandler.this);
            this.fuelSlot = new PositionedStack((Object)fuel.fuel, 39, 35);
            this.ashSlot = new PositionedStack((Object)ItemInterface.getItem((String)"ash"), 93, 24);
            this.powerPerCycle = fuel.powerPerCycle;
            this.burnDuration = fuel.burnDuration;
        }

        public PositionedStack getIngredient() {
            return this.fuelSlot;
        }

        public PositionedStack getResult() {
            return this.ashSlot;
        }
    }
}

