/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineSqueezer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import mistaqur.nei.forestry.ForestryRecipeHandler;
import net.minecraftforge.liquids.LiquidStack;

public class SqueezerRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle outputTank = new Rectangle(80, 4, 16, 58);
    static Point overlayTank = new Point(176, 0);
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    public List handleItemTooltip(GuiRecipe guiRecipe, ur stack, List currenttip, int recipe) {
        CachedSqueezerRecipe crecipe = (CachedSqueezerRecipe)this.arecipes.get(recipe);
        if (crecipe.remnants != null && guiRecipe.isMouseOver(crecipe.remnants, recipe)) {
            if (crecipe.chance < 1) {
                currenttip.add("Chance: never");
            } else if (crecipe.chance < 99) {
                currenttip.add("Chance: " + Integer.toString(crecipe.chance) + "%");
            }
        }
        return currenttip;
    }

    public String getRecipeName() {
        return "Squeezer";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 9, 15, 15), "forestry.squeezer", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.squeezer") && ((Object)((Object)this)).getClass() == SqueezerRecipeHandler.class) {
            MachineSqueezer.RecipeManager cfr_ignored_0 = (MachineSqueezer.RecipeManager)RecipeManagers.squeezerManager;
            ArrayList recipes = MachineSqueezer.RecipeManager.recipes;
            for (MachineSqueezer.Recipe irecipe : recipes) {
                this.arecipes.add(new CachedSqueezerRecipe(irecipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            MachineSqueezer.RecipeManager cfr_ignored_1 = (MachineSqueezer.RecipeManager)RecipeManagers.squeezerManager;
            ArrayList recipes = MachineSqueezer.RecipeManager.recipes;
            LiquidStack t = (LiquidStack)results[0];
            for (MachineSqueezer.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.liquid)) continue;
                this.arecipes.add(new CachedSqueezerRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        MachineSqueezer.RecipeManager cfr_ignored_0 = (MachineSqueezer.RecipeManager)RecipeManagers.squeezerManager;
        ArrayList recipes = MachineSqueezer.RecipeManager.recipes;
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        for (MachineSqueezer.Recipe irecipe : recipes) {
            if ((irecipe.remnants == null || !NEIClientUtils.areStacksSameTypeCrafting((ur)irecipe.remnants, (ur)result)) && !LiquidHelper.areSameLiquid(t, irecipe.liquid)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(irecipe).replaceMetaOnBottlerSlots(result));
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        MachineSqueezer.RecipeManager cfr_ignored_0 = (MachineSqueezer.RecipeManager)RecipeManagers.squeezerManager;
        ArrayList recipes = MachineSqueezer.RecipeManager.recipes;
        for (MachineSqueezer.Recipe irecipe : recipes) {
            CachedSqueezerRecipe recipe = new CachedSqueezerRecipe(irecipe);
            if (!recipe.contains(ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 70, 9, 176, 60, 43, 18, ((CachedSqueezerRecipe)this.arecipes.get((int)recipe)).timePerItem * 5, 0);
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/squeezer.png";
    }

    public class CachedSqueezerRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList ingredients;
        int timePerItem;
        int chance;
        PositionedStack slot_output;
        PositionedStack slot_can;
        PositionedStack remnants;
        LiquidTank output;

        public CachedSqueezerRecipe(MachineSqueezer.Recipe recipe) {
            super((TemplateRecipeHandler)SqueezerRecipeHandler.this);
            this.ingredients = new ArrayList();
            this.setIngredients(Arrays.asList(recipe.resources));
            this.output = new LiquidTank(recipe.liquid.copy(), 10000, outputTank, overlayTank);
            this.timePerItem = recipe.timePerItem;
            this.chance = recipe.chance;
            this.output.showCapacity = false;
            PositionedStack[] containers = LiquidHelper.generateStacksForLiquid(this.output.liquid, 101, 44, 135, 44);
            this.slot_can = containers[0];
            this.slot_output = containers[1];
            this.remnants = null;
            if (recipe.remnants != null && recipe.chance > 0) {
                this.remnants = new PositionedStack((Object)recipe.remnants.l(), 118, 8);
            }
        }

        public void setIngredients(List items) {
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                this.ingredients.add(new PositionedStack((Object)((ur)items.get(ingred)).l(), 14 + stackorder[ingred][0] * 18, 7 + stackorder[ingred][1] * 18));
            }
        }

        public CachedSqueezerRecipe replaceMetaOnBottlerSlots(ur ingredient) {
            if (this.slot_output.items.length == 1 && this.slot_can == null) {
                return this;
            }
            for (int i = 0; i < this.slot_output.items.length; ++i) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ur)ingredient, (ur)this.slot_output.items[i])) continue;
                this.slot_output.item = this.slot_output.items[i];
                this.slot_output.item.b(ingredient.j());
                this.slot_output.items = new ur[]{this.slot_output.item};
                this.slot_output.setPermutationToRender(0);
                this.slot_can.item = this.slot_can.items[i];
                this.slot_can.items = new ur[]{this.slot_can.item};
                this.slot_can.setPermutationToRender(0);
                break;
            }
            return this;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(SqueezerRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public boolean contains(ur ingredient) {
            return this.contains(this.ingredients, ingredient);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(SqueezerRecipeHandler.this.cycleticks / 20, this.slot_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.remnants != null) {
                stacks.add(this.remnants);
            }
            if (this.slot_can != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(SqueezerRecipeHandler.this.cycleticks / 20, this.slot_can));
            }
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.output);
            return res;
        }
    }
}

