/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.PacketCustom;
import codechicken.core.ServerUtils;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import codechicken.nei.ServerPacketHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.List;

public class ServerHandler
implements ITickHandler,
IPlayerTracker {
    private static ServerHandler instance;

    public static void load() {
        instance = new ServerHandler();
        PacketCustom.assignHandler((String)"NEI", (int)0, (int)255, (PacketCustom.ICustomPacketHandler)new ServerPacketHandler());
        TickRegistry.registerTickHandler((ITickHandler)instance, (Side)Side.SERVER);
        GameRegistry.registerPlayerTracker((IPlayerTracker)instance);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            this.processDisabledProperties((yc)tickData[0]);
        }
        if (type.contains(TickType.WORLDLOAD)) {
            NEIServerConfig.load((yc)tickData[0]);
        }
        if (type.contains(TickType.PLAYER)) {
            iq player = (iq)tickData[0];
            PlayerSave save = NEIServerConfig.forPlayer(player.bR);
            if (save == null) {
                return;
            }
            this.updateMagneticPlayer(player, save);
            this.updateOpChange(player, save);
            save.save();
        }
    }

    private void updateOpChange(iq player, PlayerSave save) {
        boolean isOp = ServerUtils.isPlayerOP((String)save.username);
        if (isOp != save.wasOp) {
            ServerPacketHandler.sendHasServerSideTo(player);
            save.wasOp = isOp;
        }
    }

    private void processDisabledProperties(yc world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isPropertyDisabled(CommonUtils.getDimension((yc)world), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    private void updateMagneticPlayer(iq player, PlayerSave save) {
        if (!save.getMagnetMode() || player.L) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = player.p.a(px.class, player.D.b((double)distancexz, (double)distancey, (double)distancexz));
        for (px item : items) {
            double rationspeedy;
            if (item.b > 0 || !NEIServerUtils.canItemFitInInventory((qx)player, item.d())) continue;
            if (item.b == 0) {
                ServerPacketHandler.sendAddMagneticItemTo(player, item);
            }
            double dx = player.t - item.t;
            double dy = player.u + (double)player.e() - item.u;
            double dz = player.v - item.v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz < 1.0) {
                item.c_((qx)player);
            }
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.w + speedxz * dx;
            double vy = item.x + speedy * dy;
            double vz = item.y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            item.w = vx;
            item.x = vy;
            item.y = vz;
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD, TickType.PLAYER, TickType.WORLDLOAD);
    }

    public String getLabel() {
        return "NEI Server";
    }

    public void onPlayerLogin(qx player) {
        NEIServerConfig.loadPlayer(player);
        ServerPacketHandler.sendHasServerSideTo((iq)player);
    }

    public void onPlayerLogout(qx player) {
        NEIServerConfig.unloadPlayer(player);
    }

    public void onPlayerChangedDimension(qx player) {
        ServerPacketHandler.sendHasServerSideTo((iq)player);
    }

    public void onPlayerRespawn(qx player) {
        ServerPacketHandler.sendHasServerSideTo((iq)player);
    }
}

