/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends aaq>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, in> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<yc, yc> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Set<Integer> leakedWorlds = Sets.newHashSet();

    public static boolean registerProviderType(int id, Class<? extends aaq> provider, boolean keepLoaded) {
        if (providers.containsKey(id)) {
            return false;
        }
        providers.put(id, provider);
        spawnSettings.put(id, keepLoaded);
        return true;
    }

    public static int[] unregisterProviderType(int id) {
        if (!providers.containsKey(id)) {
            return new int[0];
        }
        providers.remove(id);
        spawnSettings.remove(id);
        int[] ret = new int[dimensions.size()];
        int x2 = 0;
        for (Map.Entry<Integer, Integer> ent : dimensions.entrySet()) {
            if (ent.getValue() != id) continue;
            ret[x2++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x2);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerProviderType(0, aas.class, true);
        DimensionManager.registerProviderType(-1, aar.class, true);
        DimensionManager.registerProviderType(1, aat.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, provider type %d does not exist", id, providerType));
        }
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, providerType);
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static aaq getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).u;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            HashSet newLeaks = Sets.newHashSet();
            ListIterator li2 = allWorlds.listIterator();
            while (li2.hasNext()) {
                yc w2 = (yc)li2.next();
                if (leakedWorlds.contains(System.identityHashCode(w2))) {
                    li2.remove();
                }
                newLeaks.add(System.identityHashCode(w2));
            }
            leakedWorlds = newLeaks;
            if (allWorlds.size() > 0) {
                FMLLog.severe("Detected leaking worlds in memory. There are %d worlds that appear to be persisting. A mod is likely caching the world incorrectly\n", allWorlds.size() + leakedWorlds.size());
                for (yc w2 : allWorlds) {
                    FMLLog.severe("The world %x (%s) has leaked.\n", System.identityHashCode(w2), w2.K().k());
                }
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id, in world) {
        if (world != null) {
            worlds.put(id, world);
            weakWorldMap.put(world, world);
            MinecraftServer.D().worldTickTimes.put(id, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id, world.K().k(), world.o());
        } else {
            worlds.remove(id);
            MinecraftServer.D().worldTickTimes.remove(id);
            FMLLog.info("Unloading dimension %d", id);
        }
        ArrayList<in> tmp = new ArrayList<in>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, in> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.D().c = tmp.toArray(new in[tmp.size()]);
    }

    public static void initDimension(int dim) {
        in overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e2) {
            System.err.println("Cannot Hotload Dim: " + e2.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.o();
        aih savehandler = overworld.J();
        yk worldSettings = new yk(overworld.K());
        in world = dim == 0 ? overworld : new ih(mcServer, savehandler, overworld.K().k(), dim, worldSettings, overworld, mcServer.b);
        world.a(new ij(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.I()) {
            world.K().a(mcServer.g());
        }
        mcServer.c(mcServer.h());
    }

    public static in getWorld(int id) {
        return worlds.get(id);
    }

    public static in[] getWorlds() {
        return worlds.values().toArray(new in[worlds.size()]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id = DimensionManager.getProviderType(dim);
        return spawnSettings.containsKey(id) && spawnSettings.get(id) != false;
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static aaq createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                aaq provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e2) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.SEVERE, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), e2);
            throw new RuntimeException(e2);
        }
    }

    public static void unloadWorld(int id) {
        unloadQueue.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id : unloadQueue) {
            in w2 = worlds.get(id);
            try {
                if (w2 != null) {
                    w2.a(true, null);
                    continue;
                }
                FMLLog.warning("Unexpected world unload - world %d is already unloaded", id);
            }
            catch (yh e2) {
                e2.printStackTrace();
            }
            finally {
                if (w2 == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(w2));
                w2.m();
                DimensionManager.setWorld(id, null);
            }
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static bq saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        bq dimMap = new bq();
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = 0;
            for (int j2 = 0; j2 < 32; ++j2) {
                val |= dimensionMap.get(i2 * 32 + j2) ? 1 << j2 : 0;
            }
            data[i2] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(bq compoundTag) {
        if (compoundTag == null) {
            dimensionMap.clear();
            for (Integer id : dimensions.keySet()) {
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.k("DimensionArray");
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    dimensionMap.set(i2 * 32 + j2, (intArray[i2] & 1 << j2) != 0);
                }
            }
        }
    }

    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return ((ahv)DimensionManager.getWorld(0).J()).b();
        }
        if (MinecraftServer.D() != null) {
            MinecraftServer srv = MinecraftServer.D();
            ahv saveHandler = (ahv)srv.N().a(srv.J(), false);
            return saveHandler.b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }
}

