/*
 * Decompiled with CFR 0.152.
 */
package connectfour;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import connectfour.MatchData;
import connectfour.Outcome;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import server.Server;
import shared.Message;

public class GameSession
implements Runnable {
    private int m_id = sessionIDCounter++;
    private Calendar m_startTime = Calendar.getInstance();
    private String m_queueName = "Game Session " + sessionIDCounter + " Queue";
    private String[] m_players;
    private String[] m_playerQueueNames;
    private int m_numberOfPlayers;
    private byte m_currentPlayer;
    private byte m_winner;
    private byte[] m_lastPieceLocation;
    private byte[][] m_grid = new byte[7][6];
    private String m_brokerHostName;
    private ConnectionFactory m_factory;
    private Connection m_connection;
    private Channel m_channel;
    private QueueingConsumer m_consumer;
    private boolean m_initialized;
    private boolean m_running;
    private boolean m_started;
    private boolean m_sessionAborted;
    private Thread m_sessionThread;
    public static int sessionIDCounter = 1;
    public static final int MAX_PLAYERS = 2;
    public static final int GRID_WIDTH = 7;
    public static final int GRID_HEIGHT = 6;
    public static final byte UNDETERMINED = 0;
    public static final byte PLAYER1 = 1;
    public static final byte PLAYER2 = 2;
    public static final byte DRAW = 3;
    public static final String[] TABLE_HEADERS = new String[]{"ID", "Player 1", "Player 2", "Time Started", "Status"};
    public static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public GameSession() {
        this.clearGrid();
        this.m_players = new String[2];
        this.m_lastPieceLocation = new byte[2];
        this.m_playerQueueNames = new String[2];
        this.clearLastPieceLocation();
        this.m_winner = 0;
        this.m_initialized = false;
        this.m_started = false;
        this.m_sessionAborted = false;
    }

    public boolean initialize(String brokerHostName) {
        if (this.m_initialized) {
            return false;
        }
        this.m_brokerHostName = brokerHostName;
        this.m_factory = new ConnectionFactory();
        this.m_factory.setHost(this.m_brokerHostName);
        try {
            this.m_connection = this.m_factory.newConnection();
            this.m_channel = this.m_connection.createChannel();
            this.m_channel.queueDeclare(this.m_queueName, false, false, false, null);
            this.m_consumer = new QueueingConsumer(this.m_channel);
            this.m_channel.basicConsume(this.m_queueName, true, this.m_consumer);
        }
        catch (IOException e) {
            System.err.println("Error initializing messaging service: " + e.getMessage());
            return false;
        }
        this.m_initialized = true;
        this.m_sessionThread = new Thread(this);
        this.m_sessionThread.start();
        return true;
    }

    public boolean addPlayer(String userName, String userQueueName) {
        if (userName == null || userQueueName == null) {
            return false;
        }
        if (this.m_numberOfPlayers == 2) {
            return false;
        }
        this.m_players[this.m_numberOfPlayers] = userName;
        this.m_playerQueueNames[this.m_numberOfPlayers] = userQueueName;
        ++this.m_numberOfPlayers;
        return true;
    }

    public int getID() {
        return this.m_id;
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    public String getPlayerQueueName(int index) {
        if (index < 0 || index >= this.m_playerQueueNames.length) {
            return null;
        }
        return this.m_playerQueueNames[index];
    }

    public String getPlayerQueueName(String playerName) {
        int playerIndex = this.getPlayerIndex(playerName);
        if (playerIndex < 0) {
            return null;
        }
        return this.m_playerQueueNames[playerIndex];
    }

    public String getOpponentPlayerQueueName(int index) {
        if (index < 0 || index >= this.m_playerQueueNames.length) {
            return null;
        }
        return this.m_playerQueueNames[index == 0 ? 1 : 0];
    }

    public String getOpponentPlayerQueueName(String playerName) {
        int playerIndex = this.getPlayerIndex(playerName);
        if (playerIndex < 0) {
            return null;
        }
        return this.m_playerQueueNames[playerIndex == 0 ? 1 : 0];
    }

    public int numberOfPlayers() {
        return this.m_numberOfPlayers;
    }

    public boolean isStarted() {
        return this.m_started;
    }

    public boolean isFull() {
        return this.m_numberOfPlayers == 2;
    }

    public boolean isFinished() {
        return this.m_sessionAborted || this.isStarted() && (this.m_winner == 1 || this.m_winner == 2 || this.m_winner == 3);
    }

    public String getPlayerName(int index) {
        if (index < 0 || index >= this.m_numberOfPlayers) {
            return null;
        }
        return this.m_players[index];
    }

    public int getPlayerIndex(String playerName) {
        if (playerName == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_numberOfPlayers) {
            if (playerName.equalsIgnoreCase(this.m_players[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(String playerName) {
        return this.getPlayerIndex(playerName) >= 0;
    }

    public boolean playerLeft(String playerName) {
        int playerIndex = this.getPlayerIndex(playerName);
        if (playerIndex < 0) {
            return false;
        }
        this.m_sessionAborted = true;
        return true;
    }

    public Calendar getStartTime() {
        return this.m_startTime;
    }

    public String getStartTimeAsString() {
        return TIME_FORMAT.format(this.m_startTime.getTime());
    }

    public String getStatusAsString() {
        if (this.isFinished()) {
            if (this.m_winner == 1) {
                return "Finished: Player 1 Won";
            }
            if (this.m_winner == 2) {
                return "Finished: Player 2 Won";
            }
            if (this.m_winner == 3) {
                return "Finished: Draw";
            }
        } else if (this.isStarted()) {
            if (this.m_currentPlayer == 1) {
                return "Playing: Player 1's Turn";
            }
            if (this.m_currentPlayer == 2) {
                return "Playing: Player 2's Turn";
            }
        } else {
            if (this.isFull()) {
                return "Starting Game";
            }
            if (!this.isFull()) {
                return "Waiting for Opponent";
            }
        }
        return "";
    }

    public String[] getAsTableEntry() {
        return new String[]{Integer.toString(this.m_id), this.m_players[0], this.m_players[1], this.getStartTimeAsString(), this.getStatusAsString()};
    }

    public boolean startGame() {
        if (!this.isFull() || this.m_started || !this.m_initialized) {
            return false;
        }
        this.m_started = true;
        this.m_currentPlayer = (byte)(Math.random() * 2.0 + 1.0);
        Message startGame = new Message("Start Game");
        startGame.setAttribute("Current Player Name", this.m_players[this.m_currentPlayer - 1]);
        startGame.setAttribute("Player Number", Integer.toString(1));
        startGame.setAttribute("Opponent Player Name", this.m_players[1]);
        this.sendMessageToPlayer(startGame, 1);
        startGame.setAttribute("Player Number", Integer.toString(2));
        startGame.setAttribute("Opponent Player Name", this.m_players[0]);
        this.sendMessageToPlayer(startGame, 2);
        return true;
    }

    public void nextPlayer() {
        this.m_currentPlayer = (byte)(this.m_currentPlayer == 1 ? 2 : 1);
    }

    public void clearGrid() {
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 6) {
                this.m_grid[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void clearLastPieceLocation() {
        this.m_lastPieceLocation[0] = -1;
        this.m_lastPieceLocation[1] = -1;
    }

    public boolean placePiece(int column) {
        if (column < 0 || column > 7) {
            return false;
        }
        boolean placedPiece = false;
        int j = 5;
        while (j >= 0) {
            if (this.m_grid[column][j] == 0) {
                this.m_grid[column][j] = this.m_currentPlayer;
                this.m_lastPieceLocation[0] = (byte)column;
                this.m_lastPieceLocation[1] = (byte)j;
                placedPiece = true;
                break;
            }
            --j;
        }
        this.checkGameFinished();
        return placedPiece;
    }

    public boolean checkGameFinished() {
        int i;
        byte[] count = new byte[2];
        int j = 0;
        while (j < 6) {
            i = 0;
            while (i < 7) {
                if (this.checkWin(count = this.updateCount(count, i, j), i, j)) {
                    return true;
                }
                ++i;
            }
            count[0] = 0;
            count[1] = 0;
            ++j;
        }
        int i2 = 0;
        while (i2 < 7) {
            int j2 = 0;
            while (j2 < 6) {
                if (this.checkWin(count = this.updateCount(count, i2, j2), i2, j2)) {
                    return true;
                }
                ++j2;
            }
            count[0] = 0;
            count[1] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            int x = i2;
            int y = 0;
            while (GameSession.isValid(x, y)) {
                if (this.checkWin(count = this.updateCount(count, x, y), x, y)) {
                    return true;
                }
                ++x;
                ++y;
            }
            x = i2;
            y = 0;
            count[0] = 0;
            count[1] = 0;
            while (GameSession.isValid(x, y)) {
                if (this.checkWin(count = this.updateCount(count, x, y), x, y)) {
                    return true;
                }
                --x;
                ++y;
            }
            x = i2;
            y = 5;
            count[0] = 0;
            count[1] = 0;
            while (GameSession.isValid(x, y)) {
                if (this.checkWin(count = this.updateCount(count, x, y), x, y)) {
                    return true;
                }
                ++x;
                --y;
            }
            x = i2;
            y = 5;
            count[0] = 0;
            count[1] = 0;
            while (GameSession.isValid(x, y)) {
                if (this.checkWin(count = this.updateCount(count, x, y), x, y)) {
                    return true;
                }
                --x;
                --y;
            }
            count[0] = 0;
            count[1] = 0;
            ++i2;
        }
        boolean boardFull = true;
        i = 0;
        while (i < 7) {
            if (this.m_grid[i][0] == 0) {
                boardFull = false;
                break;
            }
            ++i;
        }
        if (boardFull) {
            this.m_winner = (byte)3;
            return true;
        }
        return false;
    }

    private boolean checkWin(byte[] count, int x, int y) {
        if (this.m_grid[x][y] == 0) {
            return false;
        }
        if (count[this.m_grid[x][y] - 1] == 4) {
            this.m_winner = this.m_grid[x][y];
            return true;
        }
        return false;
    }

    private byte[] updateCount(byte[] count, int x, int y) {
        if (this.m_grid[x][y] != 0) {
            int n = this.m_grid[x][y] - 1;
            count[n] = (byte)(count[n] + 1);
            count[this.m_grid[x][y] == 1 ? 1 : 0] = 0;
        } else {
            count[0] = 0;
            count[1] = 0;
        }
        return count;
    }

    public static boolean isValid(int x, int y) {
        return x >= 0 && y >= 0 && x < 7 && y < 6;
    }

    public boolean sendMessageToOpposingPlayer(Message message, int playerNumber) {
        if (playerNumber != 1 && playerNumber != 2) {
            return false;
        }
        return this.sendMessageToPlayer(message, this.m_playerQueueNames[(playerNumber == 1 ? 2 : 1) - 1]);
    }

    public boolean sendMessageToOpposingPlayer(Message message, String playerQueueName) {
        if (message == null || playerQueueName == null) {
            return false;
        }
        return this.sendMessageToPlayer(message, playerQueueName.equals(this.m_playerQueueNames[0]) ? this.m_playerQueueNames[1] : this.m_playerQueueNames[0]);
    }

    public boolean sendMessageToPlayer(Message message, int playerNumber) {
        if (playerNumber != 1 && playerNumber != 2) {
            return false;
        }
        return this.sendMessageToPlayer(message, this.m_playerQueueNames[playerNumber - 1]);
    }

    public boolean sendMessageToPlayer(Message message, String playerQueueName) {
        if (message == null || playerQueueName == null) {
            return false;
        }
        try {
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
            AMQP.BasicProperties properties = builder.contentType("text/plain").replyTo(this.m_queueName).build();
            this.m_channel.basicPublish("", playerQueueName, properties, Message.serializeMessage(message));
        }
        catch (Exception e) {
            Server.console.writeLine("Error sending message to player \"" + playerQueueName + "\": " + e.getMessage());
            return false;
        }
        return true;
    }

    public void handleMessage(QueueingConsumer.Delivery delivery) {
        if (delivery == null) {
            return;
        }
        Message message = null;
        try {
            message = Message.deserializeMessage(delivery.getBody());
        }
        catch (Exception e) {
            return;
        }
        if (message == null) {
            return;
        }
        if (message.getType().equalsIgnoreCase("Place Piece")) {
            String userName = (String)message.getAttribute("User Name");
            int columnIndex = -1;
            try {
                columnIndex = Integer.parseInt((String)message.getAttribute("Column Index"));
            }
            catch (NumberFormatException e) {
                return;
            }
            if (columnIndex < 0 || columnIndex >= 7) {
                return;
            }
            if (this.placePiece(columnIndex)) {
                Message reply = new Message("Move Valid");
                reply.setAttribute("User Name", userName);
                this.sendMessageToPlayer(reply, delivery.getProperties().getReplyTo());
                Message piecePlaced = new Message("Piece Placed");
                piecePlaced.setAttribute("User Name", userName);
                piecePlaced.setAttribute("Column Index", Integer.toString(columnIndex));
                this.sendMessageToPlayer(piecePlaced, this.m_currentPlayer == 1 ? 2 : 1);
                Server.console.writeLine("Player \"" + userName + "\"" + " placed piece at location: (" + this.m_lastPieceLocation[0] + ", " + this.m_lastPieceLocation[1] + ")");
                if (this.m_winner == 3) {
                    Message draw = new Message("Draw");
                    this.sendMessageToPlayer(draw, 1);
                    this.sendMessageToPlayer(draw, 2);
                    try {
                        Server.database.addDraw(this.m_players[0]);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    try {
                        Server.database.addDraw(this.m_players[1]);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    try {
                        Server.database.addMatch(new MatchData(Calendar.getInstance(), this.m_players[0], this.m_players[1], Outcome.Draw));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    Server.console.writeLine("Session #" + this.m_id + " ended in a draw.");
                    Server.instance.removeSession(this);
                    return;
                }
                if (this.m_winner == 1 || this.m_winner == 2) {
                    Message winner = new Message("Player Won");
                    winner.setAttribute("User Name", this.m_players[this.m_winner - 1]);
                    this.sendMessageToPlayer(winner, 1);
                    this.sendMessageToPlayer(winner, 2);
                    try {
                        Server.database.addWin(this.m_players[this.m_winner - 1]);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    try {
                        Server.database.addLoss(this.m_players[(this.m_winner == 1 ? 2 : 1) - 1]);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    try {
                        Server.database.addMatch(new MatchData(Calendar.getInstance(), this.m_players[0], this.m_players[1], this.m_winner == 1 ? Outcome.Win : Outcome.Loss));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    Server.console.writeLine("Player \"" + this.m_players[this.m_winner - 1] + "\" won the game in session #" + this.m_id + "!");
                    Server.instance.removeSession(this);
                    return;
                }
                this.nextPlayer();
            } else {
                Message reply = new Message("Move Invalid");
                reply.setAttribute("User Name", userName);
                this.sendMessageToPlayer(reply, delivery.getProperties().getReplyTo());
                Server.console.writeLine("Player \"" + userName + "\" attempted an invalid move in column: " + columnIndex);
            }
        }
    }

    public void stop() {
        this.m_initialized = false;
        this.m_running = false;
        this.m_sessionAborted = true;
        try {
            this.m_sessionThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        if (!this.m_initialized) {
            return;
        }
        this.m_running = true;
        while (this.m_running) {
            try {
                this.handleMessage(this.m_consumer.nextDelivery());
            }
            catch (InterruptedException e) {
                this.stop();
            }
            catch (ShutdownSignalException e) {
                this.stop();
            }
            catch (Exception e) {
                Server.console.writeLine("Critical error, server shutting down.");
                e.printStackTrace();
                this.stop();
            }
        }
    }
}

