/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Serializer {
    public static String readLine(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        char c = '\u0000';
        String s = new String("");
        while ((c = Serializer.readSerializedCharacter(in)) != '\n' && c != '\r') {
            s = String.valueOf(s) + c;
        }
        return s;
    }

    public static String readToken(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        char c = '\u0000';
        String s = new String("");
        while ((c = Serializer.readSerializedCharacter(in)) != '\n' && c != '\r' && c != '\t' && c != ' ') {
            s = String.valueOf(s) + c;
        }
        return s;
    }

    public static boolean writeString(String s, OutputStream out) throws IOException {
        if (s == null || out == null) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (!Serializer.writeSerializedCharacter(s.charAt(i), out)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] serializeString(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        byte[] data = new byte[s.length() * 2];
        int j = 0;
        int i = 0;
        while (i < s.length()) {
            data[j++] = (byte)(s.charAt(i) >> 8);
            data[j++] = (byte)s.charAt(i);
            ++i;
        }
        return data;
    }

    public static String deserializeString(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0 || data.length % 2 != 0) {
            return null;
        }
        String s = "";
        int i = 0;
        while (i < data.length) {
            s = String.valueOf(s) + (char)(data[i] << 8 | data[i + 1] & 0xFF);
            i += 2;
        }
        return s;
    }

    public static byte[] serializeArray(Object[] objects) throws IOException {
        if (objects == null || objects.length == 0) {
            return null;
        }
        Vector<byte[]> serializedObjects = new Vector<byte[]>(objects.length);
        int length = 4;
        byte[] serializedObject = null;
        int i = 0;
        while (i < objects.length) {
            serializedObject = Serializer.serializeObject(objects[i]);
            if (serializedObject == null) {
                throw new IOException("error serializing object");
            }
            length += 4 + serializedObject.length;
            serializedObjects.add(serializedObject);
            ++i;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(length);
        byteStream.write(Serializer.serializeInteger(serializedObjects.size()));
        int i2 = 0;
        while (i2 < serializedObjects.size()) {
            byteStream.write(Serializer.serializeInteger(((byte[])serializedObjects.elementAt(i2)).length));
            byteStream.write((byte[])serializedObjects.elementAt(i2));
            ++i2;
        }
        return byteStream.toByteArray();
    }

    public static Object[] deserializeArray(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        int numberOfObjects = -1;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        byte[] temp = new byte[4];
        byteStream.read(temp);
        numberOfObjects = Serializer.deserializeInteger(temp);
        if (numberOfObjects < 1) {
            return null;
        }
        Object[] objects = new Object[numberOfObjects];
        int i = 0;
        while (i < numberOfObjects) {
            temp = new byte[4];
            byteStream.read(temp);
            int length = Serializer.deserializeInteger(temp);
            if (length < 1) {
                return null;
            }
            temp = new byte[length];
            byteStream.read(temp);
            objects[i] = Serializer.deserializeObject(temp);
            if (objects[i] == null) {
                return null;
            }
            ++i;
        }
        return objects;
    }

    public static byte[] serializeObject(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = null;
        objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(o);
        objectStream.close();
        return byteStream.toByteArray();
    }

    public static Object deserializeObject(byte[] data) throws IOException {
        Object object;
        if (data == null || data.length < 1) {
            return null;
        }
        ObjectInputStream objectStream = null;
        try {
            objectStream = new ObjectInputStream(new ByteArrayInputStream(data));
            object = objectStream.readObject();
            objectStream.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return object;
    }

    public static Object readSerializedObject(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        int length = Serializer.readSerializedInteger(in);
        if (length < 1) {
            return null;
        }
        byte[] data = new byte[length];
        in.read(data);
        return Serializer.deserializeObject(data);
    }

    public static boolean writeSerializedObject(Object o, OutputStream out) throws IOException {
        if (o == null || out == null) {
            return false;
        }
        byte[] data = Serializer.serializeObject(o);
        if (data == null) {
            return false;
        }
        Serializer.writeSerializedInteger(data.length, out);
        out.write(data, 0, data.length);
        return true;
    }

    public static char readSerializedCharacter(InputStream in) throws IOException {
        if (in == null) {
            return '\u0000';
        }
        byte[] data = new byte[2];
        in.read(data);
        return Serializer.deserializeCharacter(data);
    }

    public static boolean writeSerializedCharacter(char c, OutputStream out) throws IOException {
        if (out == null) {
            return false;
        }
        byte[] data = Serializer.serializeCharacter(c);
        out.write(data, 0, data.length);
        return true;
    }

    public static int readSerializedInteger(InputStream in) throws IOException {
        if (in == null) {
            return -1;
        }
        byte[] data = new byte[4];
        in.read(data);
        return Serializer.deserializeInteger(data);
    }

    public static boolean writeSerializedInteger(int i, OutputStream out) throws IOException {
        if (out == null) {
            return false;
        }
        byte[] data = Serializer.serializeInteger(i);
        out.write(data, 0, data.length);
        return true;
    }

    public static byte[] serializeCharacter(char c) {
        byte[] data = new byte[]{(byte)(c >> 8), (byte)c};
        return data;
    }

    public static char deserializeCharacter(byte[] data) {
        if (data == null || data.length != 2) {
            return '\u0000';
        }
        return (char)(data[0] << 8 | data[1] & 0xFF);
    }

    public static byte[] serializeInteger(int i) {
        byte[] data = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return data;
    }

    public static int deserializeInteger(byte[] data) {
        if (data == null || data.length != 4) {
            return -1;
        }
        return data[0] << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }
}

