/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PaletteReadException;
import exception.PaletteWriteException;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import palette.Palette;
import utilities.Serializer;
import utilities.Utilities;

public class PalettePAL
extends Palette {
    protected byte[] m_data = null;
    protected short m_numberOfColours;
    public static final int BPP = 4;
    public static final int PALETTE_RIFF_OFFSET = 0;
    public static final int PALETTE_PAL_TEXT_OFFSET = 8;
    public static final int PALETTE_DATA_TEXT_OFFSET = 12;
    public static final int PALETTE_VERSION_OFFSET = 20;
    public static final int PALETTE_NUMBER_OF_COLOURS_OFFSET = 22;
    public static final int PALETTE_COLOUR_OFFSET = 24;
    public static final int HEADER_SIZE = 24;
    public static final int PALETTE_SIZE_RGB = 768;
    public static final int PALETTE_SIZE_RGBA = 1024;
    public static final String FILE_TYPE = "PAL";
    public static final String PALETTE_DESCRIPTION = "Default";
    public static final String HEADER_RIFF_TEXT = "RIFF";
    public static final String HEADER_PAL_TEXT = "PAL";
    public static final String HEADER_DATA_TEXT = "data";
    public static final short PALETTE_VERSION = 3;
    public static final byte[] BLANK_HEADER_DATA = new byte[]{82, 73, 70, 70, 16, 4, 0, 0, 80, 65, 76, 32, 100, 97, 116, 97, 4, 4, 0, 0, 0, 3, 0, 1};

    public PalettePAL() {
        this(null);
    }

    public PalettePAL(File file) {
        super(file);
    }

    public int numberOfFileTypes() {
        return 1;
    }

    public String getFileType(int n) {
        return n == 0 ? "PAL" : null;
    }

    public int indexOfFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        return "PAL".equalsIgnoreCase(string2) ? 0 : -1;
    }

    public String getPaletteDescription(int n) {
        return n == 0 ? PALETTE_DESCRIPTION : null;
    }

    public Color getPixel(int n, int n2, int n3) {
        if (!this.m_loaded || this.m_data == null || n2 < 0 || n3 < 0 || n2 > 15 || n3 > 15 || n != 0) {
            return null;
        }
        int n4 = 24 + n3 * 16 * 4 + n2 * 4;
        int n5 = this.m_data[n4] & 0xFF;
        int n6 = this.m_data[n4 + 1] & 0xFF;
        int n7 = this.m_data[n4 + 2] & 0xFF;
        if (n5 < 0 || n5 > 255) {
            System.out.println("Red channel exceeded 0-255 boundary in PAL file \"" + this.m_file.getName() + "\" with value: " + n5 + " at offset: " + n4);
        }
        if (n6 < 0 || n6 > 255) {
            System.out.println("Green channel exceeded 0-255 boundary in PAL file \"" + this.m_file.getName() + "\" with value: " + n6 + " at offset: " + n4 + 1);
        }
        if (n7 < 0 || n7 > 255) {
            System.out.println("Blue channel exceeded 0-255 boundary in PAL file \"" + this.m_file.getName() + "\" with value: " + n7 + " at offset: " + n4 + 2);
        }
        return new Color(n5 < 0 ? 0 : (n5 > 255 ? 255 : n5), n6 < 0 ? 0 : (n6 > 255 ? 255 : n6), n7 < 0 ? 0 : (n7 > 255 ? 255 : n7));
    }

    public boolean updatePixel(int n, int n2, Color color, int n3) {
        if (!this.m_loaded || this.m_data == null || color == null || n < 0 || n2 < 0 || n > 15 || n2 > 15 || n3 != 0) {
            return false;
        }
        int n4 = 24 + n2 * 16 * 4 + n * 4;
        this.m_data[n4] = (byte)color.getRed();
        this.m_data[n4 + 1] = (byte)color.getGreen();
        this.m_data[n4 + 2] = (byte)color.getBlue();
        return true;
    }

    public Color[] getColourData(int n) {
        if (n != 0 || !this.m_loaded || this.m_data == null) {
            return null;
        }
        Color[] colorArray = new Color[256];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                colorArray[i * 16 + j] = this.getPixel(j, i);
            }
        }
        return colorArray;
    }

    public boolean updateColourData(int n, int n2, Color[] colorArray) {
        int n3;
        if (n != 0) {
            return false;
        }
        int n4 = n2 * 256;
        if (colorArray.length - n4 < 256) {
            return false;
        }
        if (!this.m_loaded) {
            if (this.isInstantiable()) {
                this.m_data = new byte[1048];
                for (n3 = 0; n3 < BLANK_HEADER_DATA.length; ++n3) {
                    this.m_data[n3] = BLANK_HEADER_DATA[n3];
                }
                this.m_loaded = true;
            } else {
                return false;
            }
        }
        n3 = 0;
        int n5 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                n3 = 24 + i * 16 * 4 + j * 4;
                n5 = n4 + i * 16 + j;
                this.m_data[n3] = (byte)colorArray[n5].getRed();
                this.m_data[n3 + 1] = (byte)colorArray[n5].getGreen();
                this.m_data[n3 + 2] = (byte)colorArray[n5].getBlue();
            }
        }
        return true;
    }

    public boolean fillWithColour(Color color, int n) {
        int n2;
        if (n > 0 || color == null) {
            return false;
        }
        if (!this.m_loaded) {
            if (this.isInstantiable()) {
                this.m_data = new byte[1048];
                for (n2 = 0; n2 < BLANK_HEADER_DATA.length; ++n2) {
                    this.m_data[n2] = BLANK_HEADER_DATA[n2];
                }
                this.m_loaded = true;
            } else {
                return false;
            }
        }
        n2 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                n2 = 24 + i * 16 * 4 + j * 4;
                this.m_data[n2] = (byte)color.getRed();
                this.m_data[n2 + 1] = (byte)color.getGreen();
                this.m_data[n2 + 2] = (byte)color.getBlue();
            }
        }
        return true;
    }

    public boolean load() throws PaletteReadException {
        if (this.m_file == null || !this.m_file.exists()) {
            return false;
        }
        String string = Utilities.getFileExtension((String)this.m_file.getName());
        if (string == null) {
            throw new PaletteReadException("File " + this.m_file.getName() + " has no extension.");
        }
        if (!string.equalsIgnoreCase("PAL")) {
            throw new PaletteReadException("File " + this.m_file.getName() + " has unsupported extension: " + string);
        }
        if (this.m_file.length() > Integer.MAX_VALUE) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" is too large to store in memory.");
        }
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[(int)this.m_file.length()];
        try {
            fileInputStream = new FileInputStream(this.m_file);
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" not found.");
        }
        catch (IOException iOException) {
            throw new PaletteReadException("Error reading file \"" + this.m_file.getName() + "\": " + iOException.getMessage());
        }
        if (byArray.length <= 24) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + " is incomplete or corrupted.");
        }
        byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3]};
        String string2 = Serializer.deserializeByteString((byte[])byArray2);
        if (!string2.trim().equalsIgnoreCase(HEADER_RIFF_TEXT)) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + "\" is not a valid format, missing " + HEADER_RIFF_TEXT + " specification in header.");
        }
        byte[] byArray3 = new byte[]{byArray[8], byArray[9], byArray[10], byArray[11]};
        String string3 = Serializer.deserializeByteString((byte[])byArray3);
        if (!string3.trim().equalsIgnoreCase("PAL")) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + "\" is not a valid format, missing " + "PAL" + " specification in header.");
        }
        byte[] byArray4 = new byte[]{byArray[12], byArray[13], byArray[14], byArray[15]};
        String string4 = Serializer.deserializeByteString((byte[])byArray4);
        if (!string4.trim().equalsIgnoreCase(HEADER_DATA_TEXT)) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + "\" is not a valid format, missing " + HEADER_DATA_TEXT + " specification in header.");
        }
        byte[] byArray5 = new byte[]{byArray[20], byArray[21]};
        short s = Serializer.deserializeShort((byte[])byArray5);
        if (s != 3) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + "\" is version " + s + ", only palettes with version " + 3 + " are supported.");
        }
        byte[] byArray6 = new byte[]{byArray[23], byArray[22]};
        short s2 = Serializer.deserializeShort((byte[])byArray6);
        if (s2 != 256) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + "\" has " + s2 + " colour" + (s2 == 1 ? "" : "s") + ", only palettes with " + 256 + " colours (" + 16 + " * " + 16 + ") are supported.");
        }
        if (byArray.length < 1048) {
            throw new PaletteReadException("Palette file is corrupted or missing data, expected 1048 bytes, found " + byArray.length + " bytes.");
        }
        this.m_numberOfColours = s2;
        this.m_data = byArray;
        this.m_loaded = true;
        return true;
    }

    public boolean save(String string) throws PaletteWriteException {
        if (!this.m_loaded || this.m_file == null) {
            throw new PaletteWriteException("Palette PAL file must be loaded and initialized with a file to be saved.");
        }
        String string2 = null;
        string2 = string == null ? this.getDefaultFileType() : string.trim();
        if (!this.hasFileType(string2)) {
            throw new PaletteWriteException("PAL palette file type \"" + string2 + "\" is not supported for writing.");
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.m_file));
            ((OutputStream)bufferedOutputStream).write(this.m_data);
            ((OutputStream)bufferedOutputStream).close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PaletteWriteException("File " + this.m_file.getName() + " not found.");
        }
        catch (IOException iOException) {
            throw new PaletteWriteException("Error writing to file " + this.m_file.getName() + ": " + iOException.getMessage());
        }
    }
}

