/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PalettePluginLoadException;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import palette.PaletteEditor;
import palette.PalettePlugin;
import utilities.Task;
import utilities.Utilities;
import variable.VariableSystem;

public class PluginManager {
    private Vector<PalettePlugin> m_plugins = new Vector();

    public int numberOfPlugins() {
        return this.m_plugins.size();
    }

    public PalettePlugin getPlugin(int n) {
        if (n < 0 || n >= this.m_plugins.size()) {
            return null;
        }
        return this.m_plugins.elementAt(n);
    }

    public PalettePlugin getPlugin(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).getName().equalsIgnoreCase(string2)) continue;
            return this.m_plugins.elementAt(i);
        }
        return null;
    }

    public PalettePlugin getPluginForFileType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            for (int j = 0; j < this.m_plugins.elementAt(i).numberOfSupportedPaletteFileTypes(); ++j) {
                if (!this.m_plugins.elementAt(i).getSupportedPaletteFileType(j).equalsIgnoreCase(string2)) continue;
                return this.m_plugins.elementAt(i);
            }
        }
        return null;
    }

    public boolean hasPluginWithFileName(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            String string3 = this.m_plugins.elementAt(i).getConfigFileName();
            if (string3 == null || !string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlugin(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).getName().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPluginForFileType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            for (int j = 0; j < this.m_plugins.elementAt(i).numberOfSupportedPaletteFileTypes(); ++j) {
                if (!this.m_plugins.elementAt(i).getSupportedPaletteFileType(j).equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOfPlugin(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).getName().equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfPlugin(PalettePlugin palettePlugin) {
        if (palettePlugin == null) {
            return -1;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).equals(palettePlugin)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfPluginForFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            for (int j = 0; j < this.m_plugins.elementAt(i).numberOfSupportedPaletteFileTypes(); ++j) {
                if (!this.m_plugins.elementAt(i).getSupportedPaletteFileType(j).equalsIgnoreCase(string2)) continue;
                return i;
            }
        }
        return -1;
    }

    public int numberOfLoadedPlugins() {
        int n = 0;
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).isLoaded()) continue;
            ++n;
        }
        return n;
    }

    public String getLoadedPluginsAsString() {
        String string = new String();
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).isLoaded()) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + this.m_plugins.elementAt(i).getName();
        }
        return string;
    }

    public Vector<PalettePlugin> getLoadedPlugins() {
        Vector<PalettePlugin> vector = new Vector<PalettePlugin>();
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).isLoaded()) continue;
            vector.add(this.m_plugins.elementAt(i));
        }
        return vector;
    }

    public int numberOfLoadedInstantiablePlugins() {
        int n = 0;
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).isLoaded() || !this.m_plugins.elementAt(i).isInstantiable()) continue;
            ++n;
        }
        return n;
    }

    public String getLoadedInstantiablePluginsAsString() {
        String string = new String();
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).isLoaded() || !this.m_plugins.elementAt(i).isInstantiable()) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + this.m_plugins.elementAt(i).getName();
        }
        return string;
    }

    public Vector<PalettePlugin> getLoadedInstantiablePlugins() {
        Vector<PalettePlugin> vector = new Vector<PalettePlugin>();
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!this.m_plugins.elementAt(i).isLoaded() || !this.m_plugins.elementAt(i).isInstantiable()) continue;
            vector.add(this.m_plugins.elementAt(i));
        }
        return vector;
    }

    public String getLoadedInstantiablePluginsAsStringExcluding(String string) {
        String string2 = string == null ? null : string.trim();
        PalettePlugin palettePlugin = null;
        String string3 = new String();
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            palettePlugin = this.m_plugins.elementAt(i);
            if (!palettePlugin.isLoaded() || !palettePlugin.isInstantiable() || string2 == null || palettePlugin.numberOfSupportedPaletteFileTypes() == 1 && palettePlugin.hasSupportedPaletteFileType(string2)) continue;
            if (string3.length() > 0) {
                string3 = string3 + ", ";
            }
            string3 = string3 + this.m_plugins.elementAt(i).getName();
        }
        return string3;
    }

    public Vector<PalettePlugin> getLoadedInstantiablePluginsExcluding(String string) {
        String string2 = string == null ? null : string.trim();
        PalettePlugin palettePlugin = null;
        Vector<PalettePlugin> vector = new Vector<PalettePlugin>();
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            palettePlugin = this.m_plugins.elementAt(i);
            if (!palettePlugin.isLoaded() || !palettePlugin.isInstantiable() || string2 == null || palettePlugin.numberOfSupportedPaletteFileTypes() == 1 && palettePlugin.hasSupportedPaletteFileType(string2)) continue;
            vector.add(this.m_plugins.elementAt(i));
        }
        return vector;
    }

    public int numberOfUnloadedPlugins(File file) {
        return this.numberOfUnloadedPlugins(file, 0);
    }

    private int numberOfUnloadedPlugins(File file, int n) {
        if (file == null || !file.exists() || n > 2) {
            return 0;
        }
        if (file.isDirectory()) {
            if (n > 2) {
                return 0;
            }
            File[] fileArray = file.listFiles();
            int n2 = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                n2 += this.numberOfUnloadedPlugins(fileArray[i], n + 1);
            }
            return n2;
        }
        if (n != 2) {
            return 0;
        }
        if (!this.hasPluginWithFileName(file.getName()) && PalettePlugin.hasConfigFileType(Utilities.getFileExtension(file.getName()))) {
            try {
                if (PalettePlugin.isPalettePlugin(file)) {
                    return 1;
                }
            }
            catch (PalettePluginLoadException palettePluginLoadException) {
                PaletteEditor.console.writeLine(palettePluginLoadException.getMessage());
                return 0;
            }
        }
        return 0;
    }

    public VariableSystem getUnloadedPlugins(File file) {
        VariableSystem variableSystem = new VariableSystem();
        this.getUnloadedPlugins(file, 0, variableSystem);
        return variableSystem;
    }

    private void getUnloadedPlugins(File file, int n, VariableSystem variableSystem) {
        if (file == null || !file.exists() || n > 2 || variableSystem == null) {
            return;
        }
        if (file.isDirectory()) {
            if (n > 2) {
                return;
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.getUnloadedPlugins(fileArray[i], n + 1, variableSystem);
            }
        } else {
            if (n != 2) {
                return;
            }
            if (!this.hasPluginWithFileName(file.getName()) && PalettePlugin.hasConfigFileType(Utilities.getFileExtension(file.getName()))) {
                String string = null;
                try {
                    string = PalettePlugin.getPalettePluginName(file);
                }
                catch (PalettePluginLoadException palettePluginLoadException) {
                    PaletteEditor.console.writeLine(palettePluginLoadException.getMessage());
                }
                if (string != null) {
                    variableSystem.add(string, file.getPath());
                }
            }
        }
    }

    public void loadPlugins(File file) {
        this.loadPlugins(file, null, 0);
    }

    public void loadPlugins(File file, Task task) {
        this.loadPlugins(file, task, 0);
        if (task != null && !task.isCompleted()) {
            task.setCompleted();
        }
    }

    private void loadPlugins(File file, Task task, int n) {
        if (file == null || !file.exists() || n > 2) {
            return;
        }
        if (task != null && task.isCancelled()) {
            return;
        }
        if (file.isDirectory()) {
            if (n > 2) {
                return;
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.loadPlugins(fileArray[i], task, n + 1);
            }
        } else {
            if (n != 2) {
                return;
            }
            if (!this.hasPluginWithFileName(file.getName()) && PalettePlugin.hasConfigFileType(Utilities.getFileExtension(file.getName())) && this.loadPlugin(file) && task != null) {
                task.addProgress(1);
            }
        }
    }

    public boolean loadPlugin(File file) {
        return this.loadPlugin(file, null);
    }

    public boolean loadPlugin(File file, Task task) {
        PalettePlugin palettePlugin;
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        try {
            palettePlugin = PalettePlugin.loadFrom(file);
        }
        catch (PalettePluginLoadException palettePluginLoadException) {
            PaletteEditor.console.writeLine(palettePluginLoadException.getMessage());
            JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), palettePluginLoadException.getMessage(), "Plugin Load Failed", 0);
            if (task != null) {
                task.cancel();
            }
            return false;
        }
        if (task != null && task.isCancelled()) {
            return false;
        }
        if (palettePlugin == null) {
            if (task != null) {
                task.cancel();
            }
            return false;
        }
        palettePlugin.setConfigFileName(file.getName());
        for (int i = 0; i < this.m_plugins.size(); ++i) {
            if (!palettePlugin.hasSharedSupportedPaletteFileType(this.m_plugins.elementAt(i))) continue;
            String string = palettePlugin.getSharedSupportedPaletteFileTypesAsString(this.m_plugins.elementAt(i));
            PaletteEditor.console.writeLine("Attempted to load \"" + palettePlugin.getName() + "\" plugin for where \"" + string + "\" palette file type(s) were already supported in \"" + this.m_plugins.elementAt(i).getName() + "\" plugin.");
            JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Attempted to load \"" + palettePlugin.getName() + "\" plugin where \"" + string + "\" palette file type(s) were already supported in \"" + this.m_plugins.elementAt(i).getName() + "\" plugin.", "File Type(s) Already Supported", 0);
            if (task != null) {
                task.cancel();
            }
            return false;
        }
        this.m_plugins.add(palettePlugin);
        if (task != null) {
            task.addProgress(1);
        }
        return true;
    }
}

