/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import utilities.Utilities;
import variable.VariableSystem;

public class SettingsManager {
    private VariableSystem m_settings = new VariableSystem();
    public String settingsFileName = "Palette Editor.ini";
    public String versionFileURL = "http://www.nitro404.com/version/duke3d_palette_editor.xml";
    public boolean autoSaveSettings;
    public boolean autoLoadPlugins;
    public String pluginDirectoryName;
    public String consoleLogFileName;
    public String logDirectoryName;
    public boolean logConsole;
    public boolean supressUpdates;
    public int pixelButtonSize;
    public int paletteSpacing;
    public int windowPositionX;
    public int windowPositionY;
    public int windowWidth;
    public int windowHeight;
    public boolean autoScrollConsole;
    public int maxConsoleHistory;
    public Color backgroundColour;
    public static final String defaultSettingsFileName = "Palette Editor.ini";
    public static final String defaultVersionFileURL = "http://www.nitro404.com/version/duke3d_palette_editor.xml";
    public static final boolean defaultAutoSaveSettings = true;
    public static final boolean defaultAutoLoadPlugins = true;
    public static final String defaultPluginDirectoryName = "Plugins";
    public static final String defaultConsoleLogFileName = "Console.log";
    public static final String defaultLogDirectoryName = "Logs";
    public static final boolean defaultLogConsole = false;
    public static final boolean defaultSupressUpdates = false;
    public static final int defaultPixelButtonSize = 16;
    public static final int defaultPaletteSpacing = 32;
    public static final int defaultWindowPositionX = 0;
    public static final int defaultWindowPositionY = 0;
    public static final int defaultWindowWidth = 800;
    public static final int defaultWindowHeight = 600;
    public static final boolean defaultAutoScrollConsole = true;
    public static final int defaultMaxConsoleHistory = 512;
    public static final Color defaultBackgroundColour = new Color(238, 238, 238);

    public SettingsManager() {
        this.reset();
    }

    public void reset() {
        this.versionFileURL = defaultVersionFileURL;
        this.autoSaveSettings = true;
        this.autoLoadPlugins = true;
        this.consoleLogFileName = defaultConsoleLogFileName;
        this.pluginDirectoryName = defaultPluginDirectoryName;
        this.logDirectoryName = defaultLogDirectoryName;
        this.logConsole = false;
        this.supressUpdates = false;
        this.pixelButtonSize = 16;
        this.paletteSpacing = 32;
        this.windowPositionX = 0;
        this.windowPositionY = 0;
        this.windowWidth = 800;
        this.windowHeight = 600;
        this.autoScrollConsole = true;
        this.maxConsoleHistory = 512;
        this.backgroundColour = defaultBackgroundColour;
    }

    public boolean load() {
        return this.loadFrom(this.settingsFileName);
    }

    public boolean save() {
        return this.saveTo(this.settingsFileName);
    }

    public boolean loadFrom(String string) {
        VariableSystem variableSystem = VariableSystem.readFrom(string);
        if (variableSystem == null) {
            return false;
        }
        this.m_settings = variableSystem;
        int n = -1;
        String string2 = null;
        Point point = null;
        Dimension dimension = null;
        Color color = null;
        string2 = this.m_settings.getValue("Version File URL", "Paths");
        if (string2 != null) {
            this.versionFileURL = string2;
        }
        if ((string2 = this.m_settings.getValue("Auto-Save Settings", "Interface")) != null) {
            if ((string2 = string2.toLowerCase()).equals("true")) {
                this.autoSaveSettings = true;
            } else if (string2.equals("false")) {
                this.autoSaveSettings = false;
            }
        }
        if ((string2 = this.m_settings.getValue("Auto-Load Plugins", "Interface")) != null) {
            if ((string2 = string2.toLowerCase()).equals("true")) {
                this.autoLoadPlugins = true;
            } else if (string2.equals("false")) {
                this.autoLoadPlugins = false;
            }
        }
        if ((string2 = this.m_settings.getValue("Console Log File Name", "Paths")) != null) {
            this.consoleLogFileName = string2;
        }
        if ((string2 = this.m_settings.getValue("Plugin Directory Name", "Paths")) != null) {
            this.pluginDirectoryName = string2;
        }
        if ((string2 = this.m_settings.getValue("Log Directory Name", "Paths")) != null) {
            this.logDirectoryName = string2;
        }
        if ((string2 = this.m_settings.getValue("Log Console", "Console")) != null) {
            if ((string2 = string2.toLowerCase()).equals("true")) {
                this.logConsole = true;
            } else if (string2.equals("false")) {
                this.logConsole = false;
            }
        }
        if ((string2 = this.m_settings.getValue("Supress Update Notifications", "Interface")) != null) {
            if ((string2 = string2.toLowerCase()).equals("true")) {
                this.supressUpdates = true;
            } else if (string2.equals("false")) {
                this.supressUpdates = false;
            }
        }
        n = -1;
        try {
            n = Integer.parseInt(this.m_settings.getValue("Pixel Button Size", "Interface"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 1) {
            this.pixelButtonSize = n;
        }
        n = -1;
        try {
            n = Integer.parseInt(this.m_settings.getValue("Palette Spacing", "Interface"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 1) {
            this.paletteSpacing = n;
        }
        if ((point = Utilities.parsePoint(this.m_settings.getValue("Window Position", "Interface"))) != null && point.x > 0 && point.y > 0) {
            this.windowPositionX = point.x;
            this.windowPositionY = point.y;
        }
        if ((dimension = Utilities.parseDimension(this.m_settings.getValue("Window Size", "Interface"))) != null && dimension.width > 0 && dimension.height > 0) {
            this.windowWidth = dimension.width;
            this.windowHeight = dimension.height;
        }
        if ((string2 = this.m_settings.getValue("Auto-Scroll Console", "Console")) != null) {
            if ((string2 = string2.trim().toLowerCase()).equals("true")) {
                this.autoScrollConsole = true;
            } else if (string2.equals("false")) {
                this.autoScrollConsole = false;
            }
        }
        n = -1;
        try {
            n = Integer.parseInt(this.m_settings.getValue("Max Console History", "Console"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 1) {
            this.maxConsoleHistory = n;
        }
        if ((color = Utilities.parseColour(variableSystem.getValue("Background Colour", "Interface"))) != null) {
            this.backgroundColour = color;
        }
        return true;
    }

    public boolean saveTo(String string) {
        this.m_settings.setValue("Version File URL", this.versionFileURL, "Paths");
        this.m_settings.setValue("Auto-Save Settings", this.autoSaveSettings, "Interface");
        this.m_settings.setValue("Auto-Load Plugins", this.autoLoadPlugins, "Interface");
        this.m_settings.setValue("Console Log File Name", this.consoleLogFileName, "Paths");
        this.m_settings.setValue("Plugin Directory Name", this.pluginDirectoryName, "Paths");
        this.m_settings.setValue("Log Directory Name", this.logDirectoryName, "Paths");
        this.m_settings.setValue("Log Console", this.logConsole, "Console");
        this.m_settings.setValue("Supress Update Notifications", this.supressUpdates, "Interface");
        this.m_settings.setValue("Pixel Button Size", this.pixelButtonSize, "Interface");
        this.m_settings.setValue("Palette Spacing", this.paletteSpacing, "Interface");
        this.m_settings.setValue("Window Position", this.windowPositionX + ", " + this.windowPositionY, "Interface");
        this.m_settings.setValue("Window Size", this.windowWidth + ", " + this.windowHeight, "Interface");
        this.m_settings.setValue("Auto-Scroll Console", this.autoScrollConsole, "Console");
        this.m_settings.setValue("Max Console History", this.maxConsoleHistory, "Console");
        this.m_settings.setValue("Background Colour", this.backgroundColour.getRed() + ", " + this.backgroundColour.getGreen() + ", " + this.backgroundColour.getBlue(), "Interface");
        this.m_settings.sort();
        return this.m_settings.writeTo(string);
    }
}

