/*
 * Decompiled with CFR 0.152.
 */
package version;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import palette.PaletteEditor;
import utilities.Utilities;

public class VersionChecker {
    public static final String PROGRAM = "program";
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String DATE = "date";
    public static final String LINK = "link";

    private VersionChecker() {
    }

    public static void checkVersion() {
        VersionChecker.checkVersion(true);
    }

    public static void checkVersion(final boolean bl) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                VersionChecker.checkVersionHelper(bl);
            }
        }).start();
    }

    private static boolean checkVersionHelper(boolean bl) {
        InputStream inputStream;
        URL uRL;
        if (PaletteEditor.settings.versionFileURL == null) {
            PaletteEditor.console.writeLine("Version file URL not set, maybe reset your settings?");
            if (bl) {
                JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Version file URL not set, maybe reset your settings?", "Invalid Version File URL", 0);
            }
            return false;
        }
        try {
            uRL = new URL(PaletteEditor.settings.versionFileURL);
        }
        catch (MalformedURLException malformedURLException) {
            PaletteEditor.console.writeLine("Version file URL is invalid or malformed, please check that it is correct or reset your settings:" + malformedURLException.getMessage());
            if (bl) {
                JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Version file URL is invalid or malformed, please check that it is correct or reset your settings:" + malformedURLException.getMessage(), "Invalid URL", 0);
            }
            return false;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            PaletteEditor.console.writeLine("Failed to open stream to version file, perhaps the url is wrong or the file is missing?");
            if (bl) {
                JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Failed to open stream to version file, perhaps the url is wrong or the file is missing?", "IO Exception", 0);
            }
            return false;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        XMLEvent xMLEvent = null;
        StartElement startElement = null;
        Attribute attribute = null;
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(inputStream);
            while (xMLEventReader.hasNext()) {
                xMLEvent = xMLEventReader.nextEvent();
                if (!xMLEvent.isStartElement() || !(startElement = xMLEvent.asStartElement()).getName().getLocalPart().equalsIgnoreCase(PROGRAM)) continue;
                attribute = startElement.getAttributeByName(new QName(NAME));
                if (attribute != null) {
                    string = attribute.getValue().trim();
                }
                if (!string.equalsIgnoreCase("Duke Nukem 3D Palette Editor")) {
                    PaletteEditor.console.writeLine("Program name in version file does not match name of program: \"" + string + "\".");
                }
                if ((attribute = startElement.getAttributeByName(new QName(VERSION))) != null) {
                    string2 = attribute.getValue().trim();
                }
                if ((attribute = startElement.getAttributeByName(new QName(DATE))) != null) {
                    string3 = attribute.getValue().trim();
                }
                if ((attribute = startElement.getAttributeByName(new QName(LINK))) == null) continue;
                string4 = attribute.getValue().trim();
            }
            inputStream.close();
        }
        catch (XMLStreamException xMLStreamException) {
            PaletteEditor.console.writeLine("XML stream exception thrown while attempting to read version file stream: " + xMLStreamException.getMessage());
            if (bl) {
                JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "XML stream exception thrown while attempting to read version file stream: " + xMLStreamException.getMessage(), "XML Stream Exception", 0);
            }
            return false;
        }
        catch (IOException iOException) {
            PaletteEditor.console.writeLine("Read exception thrown while parsing version file.");
            if (bl) {
                JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Read exception thrown while parsing version file.", "IO Exception", 0);
            }
            return false;
        }
        try {
            switch (Utilities.compareVersions("1.0.1", string2)) {
                case -1: {
                    PaletteEditor.console.writeLine("A new version of Duke Nukem 3D Palette Editor is available! Download version " + string2 + " at the following link: \"" + string4 + "\".");
                    if (!bl && PaletteEditor.settings.supressUpdates) break;
                    JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "A new version of Duke Nukem 3D Palette Editor is available! Released " + string3 + ".\nDownload version " + string2 + " at the following link: \"" + string4 + "\".", "New Version Available", 1);
                    break;
                }
                case 0: {
                    PaletteEditor.console.writeLine("Duke Nukem 3D Palette Editor is up to date with version 1.0.1, released " + string3 + ".");
                    if (!bl) break;
                    JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Duke Nukem 3D Palette Editor is up to date with version 1.0.1, released " + string3 + ".", "Up to Date", 1);
                    break;
                }
                case 1: {
                    PaletteEditor.console.writeLine("Wow, you're from the future? Awesome. Hope you're enjoying your spiffy version 1.0.1 of the Duke Nukem 3D Palette Editor!");
                    JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Wow, you're from the future? Awesome.\nHope you're enjoying your spiffy version 1.0.1 of the Duke Nukem 3D Palette Editor!", "Hello Time Traveller!", 1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            PaletteEditor.console.writeLine("Version check failed: Illegal non-numerical value encountered while parsing version.");
            if (bl) {
                JOptionPane.showMessageDialog(PaletteEditor.paletteEditorWindow.getFrame(), "Version check failed: Illegal non-numerical value encountered while parsing version.", "Invalid Version", 0);
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }
}

