/*
 * Decompiled with CFR 0.152.
 */
package logger;

import java.util.Vector;
import logger.CommandLogEntry;
import logger.SystemLogEntry;
import server.ServerWindow;

public class Logger {
    private Vector<SystemLogEntry> m_systemLog = new Vector();
    private Vector<CommandLogEntry> m_commandLog = new Vector();
    private ServerWindow m_serverWindow;

    public void initialize(ServerWindow serverWindow) {
        this.m_serverWindow = serverWindow;
    }

    public int numberOfSystemLogEntries() {
        return this.m_systemLog.size();
    }

    public int numberOfCommandLogEntries() {
        return this.m_commandLog.size();
    }

    public SystemLogEntry getSystemLogEntry(int index) {
        if (index < 0 || index >= this.m_systemLog.size()) {
            return null;
        }
        return this.m_systemLog.elementAt(index);
    }

    public CommandLogEntry getCommandLogEntry(int index) {
        if (index < 0 || index >= this.m_commandLog.size()) {
            return null;
        }
        return this.m_commandLog.elementAt(index);
    }

    public Object[] getLastSystemLogEntryAsArray() {
        SystemLogEntry e = this.m_systemLog.elementAt(this.m_systemLog.size() - 1);
        return new Object[]{e.getTimeString(), e.getTypeString(), e.getText()};
    }

    public Object[] getLastCommandLogEntryAsArray() {
        CommandLogEntry e = this.m_commandLog.elementAt(this.m_commandLog.size() - 1);
        return new Object[]{e.getTimeString(), e.getUserName(), e.getText()};
    }

    public void addInfo(String text) {
        SystemLogEntry e = new SystemLogEntry(0, text);
        this.m_systemLog.add(e);
        if (this.m_serverWindow != null) {
            this.m_serverWindow.addSystemLogEntry(e);
        }
    }

    public void addWarning(String text) {
        SystemLogEntry e = new SystemLogEntry(1, text);
        this.m_systemLog.add(e);
        if (this.m_serverWindow != null) {
            this.m_serverWindow.addSystemLogEntry(e);
        }
    }

    public void addError(String text) {
        SystemLogEntry e = new SystemLogEntry(2, text);
        this.m_systemLog.add(e);
        if (this.m_serverWindow != null) {
            this.m_serverWindow.addSystemLogEntry(e);
        }
    }

    public void addCommand(String userName, String text) {
        CommandLogEntry e = new CommandLogEntry(userName, text);
        this.m_commandLog.add(e);
        this.m_serverWindow.addCommandLogEntry(e);
    }
}

