/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.util.Vector;
import logger.Logger;
import server.Client;

public class ClientDisconnectHandler
extends Thread {
    private Vector<Client> m_clients;
    private Logger m_logger;

    public void initialize(Vector<Client> clients, Logger logger) {
        this.m_clients = clients;
        this.m_logger = logger;
        if (this.m_clients == null) {
            return;
        }
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    @Override
    public void run() {
        while (true) {
            int i = 0;
            while (i < this.m_clients.size()) {
                Client c = this.m_clients.elementAt(i);
                c.addTime(100L);
                c.ping();
                if (!c.isConnected()) {
                    c.disconnect();
                    this.m_clients.remove(i);
                    --i;
                    if (c.timeout()) {
                        this.m_logger.addInfo("Client #" + c.getClientNumber() + " (" + c.getUserName() + ") timed out");
                    }
                }
                ++i;
            }
            try {
                ClientDisconnectHandler.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

