/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import logger.Logger;
import org.sqlite.JDBC;
import server.Client;
import server.SQLResult;
import shared.Globals;
import shared.StatusType;
import shared.UserNetworkData;

public class UserDBMS {
    private Connection sqlConnection = null;
    private boolean m_connected = false;
    private Statement stmt = null;
    public static final String databaseFileName = "serious.db";
    public static final String userDataTableName = "UserData";
    public static final String userGroupTableName = "UserGroup";
    public static final String userProfileTableName = "UserProfile";
    public static final String userContactTableName = "UserContact";
    private Logger m_logger;

    public void initialize(Logger logger) {
        this.m_logger = logger;
    }

    public void connect() {
        this.m_logger.addInfo("Connecting to SQL Database: serious.db");
        try {
            this.m_connected = true;
            DriverManager.registerDriver((Driver)new JDBC());
            this.sqlConnection = DriverManager.getConnection("jdbc:sqlite:serious.db");
            this.m_logger.addInfo("Connected to SQL Database");
            this.stmt = this.sqlConnection.createStatement();
        }
        catch (SQLException e) {
            this.m_connected = false;
            this.m_logger.addError("Error connecting to SQL database: " + e.getMessage());
        }
    }

    public void disconnect() {
        try {
            this.m_connected = false;
            this.stmt = null;
            this.sqlConnection.close();
            this.m_logger.addInfo("Disconnected from SQL Database");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error disconnecting from SQL database: " + e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public void resetTables() {
        this.dropTables();
        this.createTables();
    }

    public void dropTables() {
        this.dropUserProfileTable();
        this.dropUserContactTable();
        this.dropUserGroupTable();
        this.dropUserDataTable();
    }

    public void createTables() {
        this.createUserDataTable();
        this.createUserProfileTable();
        this.createUserGroupTable();
        this.createUserContactTable();
    }

    public void dropUserProfileTable() {
        try {
            this.stmt.executeUpdate("DROP TABLE IF EXISTS UserProfile");
            this.m_logger.addInfo("Dropped table UserProfile");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error dropping table UserProfile table: " + e.getMessage());
        }
    }

    public void dropUserContactTable() {
        try {
            this.stmt.executeUpdate("DROP TABLE IF EXISTS UserContact");
            this.m_logger.addInfo("Dropped table UserContact");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error dropping table UserContact table: " + e.getMessage());
        }
    }

    public void dropUserGroupTable() {
        try {
            this.stmt.executeUpdate("DROP TABLE IF EXISTS UserGroup");
            this.m_logger.addInfo("Dropped table UserGroup");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error dropping table UserGroup table: " + e.getMessage());
        }
    }

    public void dropUserDataTable() {
        try {
            this.stmt.executeUpdate("DROP TABLE IF EXISTS UserData");
            this.m_logger.addInfo("Dropped table UserData");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error dropping table UserData table: " + e.getMessage());
        }
    }

    public void createUserDataTable() {
        try {
            this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS UserData (UserName\t\t\tVARCHAR(32)\t\tNOT NULL,Password\t\t\tVARCHAR(32)\t\tNOT NULL,NickName\t\t\tVARCHAR(128)\tNOT NULL,PersonalMessage\tVARCHAR(256)\tNOT NULL,Status\t\t\t\tTINYINT\t\t\tNOT NULL,LastLogin\t\t\tDATETIME\t\tNOT NULL,JoinDate\t\t\tDATETIME\t\tNOT NULL,PRIMARY KEY(UserName))");
            this.m_logger.addInfo("Created table UserData");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error creating table UserData table: " + e.getMessage());
        }
    }

    public void createUserGroupTable() {
        try {
            this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS UserGroup (UserName\t\tVARCHAR(32)\t\tNOT NULL,GroupName\t\tVARCHAR(32)\t\tNOT NULL,PRIMARY KEY(UserName, GroupName),FOREIGN KEY(UserName) REFERENCES UserData(UserName))");
            this.m_logger.addInfo("Created table UserGroup");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error creating table UserGroup table: " + e.getMessage());
        }
    }

    public void createUserProfileTable() {
        try {
            this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS UserProfile (UserName\t\tVARCHAR(32)\t\tNOT NULL,FirstName\t\tVARCHAR(32)\t\tNOT NULL,MiddleName\t\tVARCHAR(32),LastName\t\tVARCHAR(32) \tNOT NULL,Gender\t\t\tCHAR\t\t\tNOT NULL,BirthDate\t\tDATETIME\t\tNOT NULL,Email\t\t\tVARCHAR(64),HomePhone\t\tVARCHAR(10),MobilePhone\tVARCHAR(10),WorkPhone\t\tVARCHAR(10),Country\t\tVARCHAR(32)\t\tNOT NULL,StateProv\t\tVARCHAR(32)\t\tNOT NULL,City\t\t\tVARCHAR(32)\t\tNOT NULL,ZipPostal\t\tVARCHAR(6)\t\tNOT NULL,PRIMARY KEY(UserName),FOREIGN KEY(UserName) REFERENCES UserData(UserName))");
            this.m_logger.addInfo("Created table UserProfile");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error creating table UserProfile table: " + e.getMessage());
        }
    }

    public void createUserContactTable() {
        try {
            this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS UserContact (UserName\t\tVARCHAR(32)\t\tNOT NULL,Contact\t\tVARCHAR(32)\t\tNOT NULL,GroupName\t\tVARCHAR(32)\t\tNOT NULL,Blocked\t\tINT\t\t\t\tNOT NULL DEFAULT 0,PRIMARY KEY(UserName, Contact),FOREIGN KEY(UserName) REFERENCES UserData(UserName),FOREIGN KEY(Contact) REFERENCES UserData(UserName),FOREIGN KEY(GroupName) REFERENCES UserGroup(GroupName))");
            this.m_logger.addInfo("Created table UserContact");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error creating table UserContact table: " + e.getMessage());
        }
    }

    public Vector<UserNetworkData> getUserContacts(String userName, Vector<Client> clients) {
        if (userName == null || clients == null) {
            return null;
        }
        try {
            SQLResult result = new SQLResult(this.stmt.executeQuery("SELECT * FROM UserContact WHERE UserName = '" + userName + "'"));
            Vector<UserNetworkData> contacts = new Vector<UserNetworkData>();
            int i = 0;
            while (i < result.getRowCount()) {
                String contactUserName = result.getElement(i, 1);
                boolean contactHasUserBlocked = false;
                SQLResult result2 = new SQLResult(this.stmt.executeQuery("SELECT * FROM UserContact WHERE UserName = '" + contactUserName + "' " + "AND Contact = '" + userName + "'"));
                if (result2.getRowCount() != 0) {
                    try {
                        contactHasUserBlocked = Integer.parseInt(result2.getElement(0, 3)) != 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!contactHasUserBlocked) {
                    boolean contactBlocked = false;
                    try {
                        contactBlocked = Integer.parseInt(result.getElement(i, 3)) != 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Client client = null;
                    int j = 0;
                    while (j < clients.size()) {
                        String clientUserName = clients.elementAt(j).getUserName();
                        if (clientUserName != null && clientUserName.equalsIgnoreCase(contactUserName)) {
                            client = clients.elementAt(j);
                            break;
                        }
                        ++j;
                    }
                    SQLResult result3 = new SQLResult(this.stmt.executeQuery("SELECT * FROM UserData WHERE UserName = '" + contactUserName + "'"));
                    String contactNickName = null;
                    String contactPersonalMessage = null;
                    byte contactStatus = 0;
                    if (result3.getRowCount() != 0) {
                        contactNickName = result3.getElement(0, 2);
                        contactPersonalMessage = result3.getElement(0, 3);
                        try {
                            contactStatus = Byte.parseByte(result3.getElement(0, 4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    contacts.add(new UserNetworkData(contactUserName, contactNickName, contactPersonalMessage, contactStatus, Globals.DEFAULT_FONTSTYLE, contactBlocked, client == null ? null : client.getIPAddress(), client == null ? 0 : client.getPort()));
                }
                ++i;
            }
            this.m_logger.addInfo("Collected contact list for user " + userName);
            return contacts;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error collecting contacts for user " + userName + ": " + e.getMessage());
            return null;
        }
    }

    public boolean createUser(String userName, String password) {
        boolean userCreated;
        block5: {
            if (userName == null || password == null) {
                return false;
            }
            try {
                if (new SQLResult(this.stmt.executeQuery("SELECT * FROM UserData WHERE UserName = '" + userName + "' ")).getRowCount() == 0) break block5;
                return false;
            }
            catch (SQLException e) {
                this.m_logger.addError("Error adding user " + userName + " to database: " + e.getMessage());
                return false;
            }
        }
        boolean bl = userCreated = this.stmt.executeUpdate("INSERT INTO UserData VALUES('" + userName + "', " + "'" + password + "', " + "'" + userName + "', " + "'', " + "'" + 0 + "', " + "CURRENT_TIMESTAMP, " + "CURRENT_TIMESTAMP" + ")") != 0;
        if (userCreated) {
            this.m_logger.addInfo("Added user " + userName + " to database");
        }
        return userCreated;
    }

    public boolean deleteUser(String userName) {
        if (userName == null) {
            return false;
        }
        boolean userDeleted = false;
        try {
            userDeleted = this.stmt.executeUpdate("DELETE FROM UserProfile WHERE UserName = '" + userName + "'") != 0 || userDeleted;
            userDeleted = this.stmt.executeUpdate("DELETE FROM UserContact WHERE UserName = '" + userName + "' OR Contact = '" + userName + "'") != 0 || userDeleted;
            userDeleted = this.stmt.executeUpdate("DELETE FROM UserGroup WHERE UserName = '" + userName + "'") != 0 || userDeleted;
            boolean bl = userDeleted = this.stmt.executeUpdate("DELETE FROM UserData WHERE UserName = '" + userName + "'") != 0 || userDeleted;
            if (userDeleted) {
                this.m_logger.addInfo("Deleted user " + userName + " from database");
            }
        }
        catch (SQLException e) {
            this.m_logger.addError("Error deleting " + userName + " from database: " + e.getMessage());
        }
        return userDeleted;
    }

    public boolean createUserProfile(String userName, String firstName, String middleName, String lastName, char gender, String birthDate, String email, String homePhone, String mobilePhone, String workPhone, String country, String stateProvince, String zipPostalCode) {
        if (userName == null || firstName == null || middleName == null || lastName == null || birthDate == null || email == null || homePhone == null || mobilePhone == null || workPhone == null || country == null || stateProvince == null || zipPostalCode == null) {
            return false;
        }
        if (gender != 'm' && gender != 'M' && gender != 'f' && gender != 'F') {
            return false;
        }
        try {
            this.stmt.executeUpdate("INSERT INTO UserProfile VALUES('" + userName + "', " + "'" + firstName + "', " + "'" + middleName + "', " + "'" + lastName + "', " + "'" + gender + "', " + "'" + birthDate + "', " + "'" + email + "', " + "'" + homePhone + "', " + "'" + mobilePhone + "', " + "'" + workPhone + "', " + "'" + country + "', " + "'" + stateProvince + "', " + "'" + zipPostalCode + "'" + ")");
            this.m_logger.addInfo("Created profile for user " + userName);
            return true;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error creating profile for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean updateUserProfile(String userName, String firstName, String middleName, String lastName, char gender, String birthDate, String email, String homePhone, String mobilePhone, String workPhone, String country, String stateProvince, String zipPostalCode) {
        if (userName == null || firstName == null || middleName == null || lastName == null || birthDate == null || email == null || homePhone == null || mobilePhone == null || workPhone == null || country == null || stateProvince == null || zipPostalCode == null) {
            return false;
        }
        if (gender != 'm' && gender != 'M' && gender != 'f' && gender != 'F') {
            return false;
        }
        try {
            this.stmt.executeUpdate("UPDATE UserProfile SET FirstName = '" + firstName + "', " + "MiddleName = '" + middleName + "', " + "LastName = '" + lastName + "', " + "Gender = '" + gender + "', " + "BirthDate = '" + birthDate + "', " + "Email = '" + email + "', " + "HomePhone = '" + homePhone + "', " + "MobilePhone = '" + mobilePhone + "', " + "WorkPhone = '" + workPhone + "', " + "Country = '" + country + "', " + "StateProv = '" + stateProvince + "', " + "ZipPostal = '" + zipPostalCode + "' " + "WHERE UserName = '" + userName + "'");
            this.m_logger.addInfo("Updated profile for user " + userName);
            return true;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error updating profile for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean removeUserProfile(String userName) {
        if (userName == null) {
            return false;
        }
        try {
            this.stmt.executeUpdate("DELETE FROM UserProfile WHERE UserName = '" + userName + "'");
            this.m_logger.addInfo("Removed profile for user " + userName);
            return true;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error removing profile for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean userLogin(String userName, String password) {
        if (userName == null || password == null) {
            return false;
        }
        try {
            boolean authenticated;
            boolean bl = authenticated = this.stmt.executeUpdate("UPDATE UserData SET LastLogin = CURRENT_TIMESTAMP WHERE UserName = '" + userName + "' " + "AND Password = '" + password + "'") != 0;
            if (authenticated) {
                this.m_logger.addInfo("User " + userName + " logged in");
            }
            return authenticated;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error processing login request for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean userLogout(String userName) {
        if (userName == null) {
            return false;
        }
        try {
            this.stmt.executeUpdate("UPDATE UserData SET LastLogin = CURRENT_TIMESTAMP WHERE UserName = '" + userName + "'");
            this.m_logger.addInfo("User " + userName + " logged out");
            return true;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error processing logout request for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean changeUserPassword(String userName, String oldPassword, String newPassword) {
        if (userName == null || oldPassword == null || newPassword == null) {
            return false;
        }
        try {
            boolean passwordChanged;
            boolean bl = passwordChanged = this.stmt.executeUpdate("UPDATE UserData SET Password = '" + newPassword + "' " + "WHERE UserName = '" + userName + "' " + "AND Password = '" + oldPassword + "'") != 0;
            if (passwordChanged) {
                this.m_logger.addInfo("Changed password for user " + userName);
            }
            return passwordChanged;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error changing password for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public String getUserNickName(String userName) {
        SQLResult result;
        block4: {
            if (userName == null) {
                return null;
            }
            try {
                result = new SQLResult(this.stmt.executeQuery("SELECT NickName FROM UserData WHERE UserName = '" + userName + "'"));
                if (result.getRowCount() != 0) break block4;
                return null;
            }
            catch (SQLException e) {
                this.m_logger.addError("Error retrieving nickname for user " + userName + ": " + e.getMessage());
                return null;
            }
        }
        this.m_logger.addInfo("Retrieved nickname for user " + userName);
        return result.getElement(0, 0);
    }

    public String getUserPersonalMessage(String userName) {
        SQLResult result;
        block4: {
            if (userName == null) {
                return null;
            }
            try {
                result = new SQLResult(this.stmt.executeQuery("SELECT PersonalMessage FROM UserData WHERE UserName = '" + userName + "'"));
                if (result.getRowCount() != 0) break block4;
                return null;
            }
            catch (SQLException e) {
                this.m_logger.addError("Error retrieving personal message for user " + userName + ": " + e.getMessage());
                return null;
            }
        }
        this.m_logger.addInfo("Retrieved personal message for user " + userName);
        return result.getElement(0, 0);
    }

    public boolean updateUserNickName(String userName, String nickName) {
        if (userName == null || nickName == null) {
            return false;
        }
        try {
            boolean nickNameUpdated;
            boolean bl = nickNameUpdated = this.stmt.executeUpdate("UPDATE UserData SET NickName = '" + nickName + "' " + "WHERE UserName = '" + userName + "'") != 0;
            if (nickNameUpdated) {
                this.m_logger.addInfo("Updated nickname for user " + userName);
            }
            return nickNameUpdated;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error updating nickname for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean updateUserPersonalMessage(String userName, String personalMessage) {
        if (userName == null || personalMessage == null) {
            return false;
        }
        try {
            boolean personalMessageUpdated;
            boolean bl = personalMessageUpdated = this.stmt.executeUpdate("UPDATE UserData SET PersonalMessage = '" + personalMessage + "' " + "WHERE UserName = '" + userName + "'") != 0;
            if (personalMessageUpdated) {
                this.m_logger.addInfo("Updated personal message for user " + userName);
            }
            return personalMessageUpdated;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error updating personal message for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean updateUserStatus(String userName, byte status) {
        if (userName == null || !StatusType.isValid(status)) {
            return false;
        }
        try {
            boolean statusUpdated;
            boolean bl = statusUpdated = this.stmt.executeUpdate("UPDATE UserData SET Status = '" + status + "' " + "WHERE UserName = '" + userName + "'") != 0;
            if (statusUpdated) {
                this.m_logger.addInfo("Updated status for user " + userName);
            }
            return statusUpdated;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error updating status for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public UserNetworkData addUserContact(String userName, String contactUserName) {
        boolean contactAdded;
        block5: {
            if (userName == null || contactUserName == null) {
                return null;
            }
            try {
                SQLResult contactResult = new SQLResult(this.stmt.executeQuery("SELECT * FROM UserData WHERE UserName = '" + contactUserName + "'"));
                if (contactResult.getRowCount() == 1) break block5;
                return null;
            }
            catch (SQLException e) {
                this.m_logger.addError("Error adding contact " + contactUserName + " for user " + userName + ": " + e.getMessage());
                return null;
            }
        }
        boolean bl = contactAdded = this.stmt.executeUpdate("INSERT INTO UserContact VALUES('" + userName + "', " + "'" + contactUserName + "', " + "'', " + "0" + ")") != 0;
        if (contactAdded) {
            this.m_logger.addInfo("User " + userName + " added contact " + contactUserName);
        }
        return new UserNetworkData(contactUserName, null, null, 0, Globals.DEFAULT_FONTSTYLE);
    }

    public boolean deleteUserContact(String userName, String contactUserName) {
        if (userName == null || contactUserName == null) {
            return false;
        }
        try {
            boolean contactDeleted;
            boolean bl = contactDeleted = this.stmt.executeUpdate("DELETE FROM UserContact WHERE UserName = '" + userName + "' " + "AND Contact = '" + contactUserName + "'") != 0;
            if (contactDeleted) {
                this.m_logger.addInfo("User " + userName + " deleted contact " + contactUserName);
            }
            return contactDeleted;
        }
        catch (SQLException e) {
            this.m_logger.addError("Error deleting contact " + contactUserName + " for user " + userName + ": " + e.getMessage());
            return false;
        }
    }

    public boolean userHasContactBlocked(String userName, String contactUserName) {
        int columnIndex;
        SQLResult result;
        block11: {
            block10: {
                if (userName == null || contactUserName == null) {
                    return false;
                }
                try {
                    result = new SQLResult(this.stmt.executeQuery("SELECT * FROM UserContact WHERE UserName = '" + userName + "' " + "AND Contact = '" + contactUserName + "'"));
                    columnIndex = -1;
                    int i = 0;
                    while (i < result.getColumnCount()) {
                        if (result.getHeader(i).equalsIgnoreCase("Blocked")) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (columnIndex != -1) break block10;
                    return false;
                }
                catch (SQLException sQLException) {
                    return false;
                }
            }
            if (result.getRowCount() != 0) break block11;
            return false;
        }
        boolean blocked = false;
        try {
            blocked = Integer.parseInt(result.getElement(0, columnIndex)) == 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
        return blocked;
    }

    public int setBlockUserContact(String userName, String contactUserName, boolean blocked) {
        int columnIndex;
        SQLResult result;
        block11: {
            block10: {
                if (userName == null || contactUserName == null) {
                    return 2;
                }
                this.stmt.executeUpdate("UPDATE UserContact SET Blocked = '" + (blocked ? 1 : 0) + "' " + "WHERE UserName = '" + userName + "' " + "AND Contact = '" + contactUserName + "'");
                result = new SQLResult(this.stmt.executeQuery("SELECT * FROM UserContact WHERE UserName = '" + userName + "' " + "AND Contact = '" + contactUserName + "'"));
                if (result.getRowCount() == 1) break block10;
                return 2;
            }
            try {
                columnIndex = -1;
                int i = 0;
                while (i < result.getColumnCount()) {
                    if (result.getHeader(i).equalsIgnoreCase("Blocked")) {
                        columnIndex = i;
                        break;
                    }
                    ++i;
                }
                if (columnIndex != -1) break block11;
                return 2;
            }
            catch (SQLException e) {
                this.m_logger.addError("Error " + (blocked ? "" : "un") + "blocking contact " + contactUserName + " for user " + userName + ": " + e.getMessage());
                return 2;
            }
        }
        int blockedValue = 0;
        try {
            blockedValue = Integer.parseInt(result.getElement(0, columnIndex));
        }
        catch (NumberFormatException e) {
            return 2;
        }
        this.m_logger.addInfo("User " + userName + " " + (blocked ? "" : "un") + "blocked contact " + contactUserName);
        return blockedValue;
    }

    public int executeUpdate(String query) {
        int updated = -1;
        if (query == null) {
            return updated;
        }
        try {
            updated = this.stmt.executeUpdate(query);
            this.m_logger.addInfo("Executed custom update");
        }
        catch (SQLException e) {
            this.m_logger.addError("Error executing custom update: " + e.getMessage());
        }
        return updated;
    }

    public SQLResult executeQuery(String query) {
        if (query == null) {
            return null;
        }
        try {
            ResultSet rs = this.stmt.executeQuery(query);
            this.m_logger.addInfo("Executed custom query");
            return new SQLResult(rs);
        }
        catch (SQLException e) {
            this.m_logger.addError("Error executing custom query: " + e.getMessage());
            return null;
        }
    }

    public void updateTable(String tableName, JTable table) {
        if (tableName == null || table == null) {
            return;
        }
        try {
            DefaultTableModel tableModel = new DefaultTableModel();
            ResultSet rs = this.stmt.executeQuery("SELECT * FROM " + tableName);
            ResultSetMetaData meta = rs.getMetaData();
            int numberOfColumns = meta.getColumnCount();
            Object[] columnNames = new String[numberOfColumns];
            int i = 1;
            while (i <= numberOfColumns) {
                columnNames[i - 1] = meta.getColumnName(i);
                tableModel.addColumn(meta.getColumnName(i));
                ++i;
            }
            tableModel.setColumnIdentifiers(columnNames);
            table.setModel(tableModel);
            while (rs.next()) {
                Object[] rowData = new String[numberOfColumns];
                int i2 = 1;
                while (i2 <= numberOfColumns) {
                    rowData[i2 - 1] = rs.getString(i2);
                    ++i2;
                }
                tableModel.addRow(rowData);
            }
            table.setModel(tableModel);
        }
        catch (SQLException e) {
            this.m_logger.addError("Error updating table " + tableName + ": " + e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

