/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Component;
import java.util.ArrayDeque;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import shared.MessageBox;

public class MessageBoxSystem
extends Thread {
    private ArrayDeque<MessageBox> m_messages;

    public void show(Component parentComponent, Object message) {
        this.m_messages.add(new MessageBox(parentComponent, message));
    }

    public void show(Component parentComponent, Object message, String title, int messageType) {
        this.m_messages.add(new MessageBox(parentComponent, message, title, messageType));
    }

    public void show(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        this.m_messages.add(new MessageBox(parentComponent, message, title, messageType, icon));
    }

    public void show(MessageBox messageBox) {
        if (messageBox != null) {
            this.m_messages.add(messageBox);
        }
    }

    public void initialize() {
        this.m_messages = new ArrayDeque();
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    @Override
    public void run() {
        MessageBox box = null;
        while (true) {
            if (!this.m_messages.isEmpty()) {
                box = this.m_messages.remove();
                if (box.constructor == 1) {
                    JOptionPane.showMessageDialog(box.parentComponent, box.message);
                } else if (box.constructor == 2) {
                    JOptionPane.showMessageDialog(box.parentComponent, box.message, box.title, box.messageType);
                } else if (box.constructor == 3) {
                    JOptionPane.showMessageDialog(box.parentComponent, box.message, box.title, box.messageType, box.icon);
                }
            }
            try {
                MessageBoxSystem.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

