/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ChangePersonalMessageSignal
extends Signal {
    private String m_userName;
    private String m_personalMessage;
    public static final int LENGTH = 584;

    private ChangePersonalMessageSignal() {
        super(19);
    }

    public ChangePersonalMessageSignal(String userName, String personalMessage) {
        super(19);
        this.m_userName = userName;
        this.m_personalMessage = personalMessage;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getPersonalMessage() {
        return this.m_personalMessage;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_personalMessage, 256);
    }

    public static ChangePersonalMessageSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ChangePersonalMessageSignal s2 = new ChangePersonalMessageSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_personalMessage = byteStream.nextString(256);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_personalMessage, 256);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ChangePersonalMessageSignal.readFrom(byteStream);
    }
}

