/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import shared.Globals;
import shared.UserData;
import signal.Signal;

public class LoginAuthenticatedSignal
extends Signal {
    private UserData m_data;
    private boolean m_authenticated;
    private int m_port;
    public static final int LENGTH = 928;

    private LoginAuthenticatedSignal() {
        super(4);
    }

    public LoginAuthenticatedSignal(String userName, String nickName, String personalMessage, boolean authenticated, int port) {
        super(4);
        this.m_data = new UserData(userName, nickName, personalMessage, 1, Globals.DEFAULT_FONTSTYLE);
        this.m_authenticated = authenticated;
        this.m_port = port;
    }

    public LoginAuthenticatedSignal(UserData data, boolean authenticated, int port) {
        super(4);
        this.m_data = data;
        this.m_authenticated = authenticated;
        this.m_port = port;
    }

    public UserData getData() {
        return this.m_data;
    }

    public boolean getAuthenticated() {
        return this.m_authenticated;
    }

    public int getPort() {
        return this.m_port;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += this.m_data.checksum();
        checksum += ByteStream.getChecksum(this.m_authenticated);
        return checksum += ByteStream.getChecksum(this.m_port);
    }

    public static LoginAuthenticatedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        LoginAuthenticatedSignal s2 = new LoginAuthenticatedSignal();
        s2.m_data = UserData.readFrom(byteStream);
        s2.m_authenticated = byteStream.nextBoolean();
        s2.m_port = byteStream.nextInteger();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        this.m_data.writeTo(byteStream);
        byteStream.addBoolean(this.m_authenticated);
        byteStream.addInteger(this.m_port);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return LoginAuthenticatedSignal.readFrom(byteStream);
    }
}

