/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.settings;

import com.rbcapp.settings.RBCSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RBCSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -8848862534987424146L;
    private static Integer[] stations = new Integer[]{1, 2, 3};
    private RBCSettings settings;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel robotIdLabel;
    private JComboBox robotId;
    private JLabel currentStationLabel;
    private JComboBox currentStation;
    private JLabel station1AddressLabel;
    private JTextField station1Address;
    private JLabel station2AddressLabel;
    private JTextField station2Address;
    private JLabel station3AddressLabel;
    private JTextField station3Address;
    private JLabel outputFileLabel;
    private JTextField outputFile;
    private JPanel buttonBar;
    private JLabel blueComPortLabel;
    private JTextField blueComPort;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel filePanel;
    private JButton browseButton;
    private Vector<String> robots;

    public RBCSettingsWindow(RBCSettings setts) {
        this.settings = setts;
        this.initComponents();
        this.inputSettings();
    }

    private void initComponents() {
        this.robots = new Vector();
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.robotIdLabel = new JLabel();
        this.robotId = new JComboBox<String>(this.robots);
        this.currentStationLabel = new JLabel();
        this.currentStation = new JComboBox<Integer>(stations);
        this.station1AddressLabel = new JLabel();
        this.station1Address = new JTextField();
        this.station2AddressLabel = new JLabel();
        this.station2Address = new JTextField();
        this.station3AddressLabel = new JLabel();
        this.station3Address = new JTextField();
        this.outputFileLabel = new JLabel();
        this.outputFile = new JTextField();
        this.filePanel = new JPanel();
        this.buttonBar = new JPanel();
        this.blueComPortLabel = new JLabel();
        this.blueComPort = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.browseButton = new JButton();
        this.setMinimumSize(new Dimension(160, 36));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[3];
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[6];
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.robotIdLabel.setText("Current Robot Id:");
        this.robotIdLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.robotIdLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.contentPanel.add((Component)this.robotId, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.currentStationLabel.setText("Current Station:");
        this.currentStationLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.currentStationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.contentPanel.add((Component)this.currentStation, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.station1AddressLabel.setText("Station 1 Address:");
        this.station1AddressLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.station1AddressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.addEnterListener(this.station1Address);
        this.contentPanel.add((Component)this.station1Address, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.station2AddressLabel.setText("Station 2 Address:");
        this.station2AddressLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.station2AddressLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.addEnterListener(this.station2Address);
        this.contentPanel.add((Component)this.station2Address, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.station3AddressLabel.setText("Station 3 Address:");
        this.station3AddressLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.station3AddressLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.addEnterListener(this.station3Address);
        this.contentPanel.add((Component)this.station3Address, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.outputFileLabel.setText("Log Output File:");
        this.outputFileLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.outputFileLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.addEnterListener(this.outputFile);
        this.contentPanel.add((Component)this.filePanel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.filePanel.setLayout(null);
        this.outputFile.setLocation(0, 0);
        this.outputFile.setSize(184, 20);
        this.filePanel.add(this.outputFile);
        this.browseButton.setText("...");
        this.browseButton.setLocation(185, 0);
        this.browseButton.setSize(28, 20);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(new File("."));
                chooser.setDialogTitle("Choose location to have the output saved to");
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal == 0) {
                    RBCSettingsWindow.this.outputFile.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.filePanel.add(this.browseButton);
        this.blueComPortLabel.setText("Application Port #:");
        this.blueComPortLabel.setHorizontalAlignment(4);
        this.contentPanel.add((Component)this.blueComPortLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.addEnterListener(this.blueComPort);
        this.contentPanel.add((Component)this.blueComPort, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        int[] nArray = new int[3];
        nArray[1] = 85;
        nArray[2] = 80;
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = nArray;
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCSettingsWindow.this.okButtonHit();
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCSettingsWindow.this.cancelButtonHit();
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(355, 274);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setTitle("Settings");
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                RBCSettingsWindow.this.cancelButtonHit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModal(true);
    }

    private void addEnterListener(JTextField field) {
        field.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RBCSettingsWindow.this.okButtonHit();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void inputSettings() {
        this.currentStation.setSelectedIndex(this.settings.currentStation - 1);
        this.station1Address.setText(new String(this.settings.station1Address));
        this.station2Address.setText(new String(this.settings.station2Address));
        this.station3Address.setText(new String(this.settings.station3Address));
        this.outputFile.setText(new String(this.settings.fileOutputName));
        this.blueComPort.setText(new String(String.valueOf(this.settings.comPort)));
        Object[] keys = this.settings.robotAddresses.keySet().toArray();
        this.robots.removeAllElements();
        int selection = 0;
        int i = 0;
        while (i < keys.length) {
            int id = (Integer)keys[i];
            if (id == this.settings.robotId) {
                selection = i;
            }
            String value = this.settings.robotAddresses.get(id);
            this.robots.add(id + ":" + value);
            ++i;
        }
        this.robotId.setSelectedIndex(selection);
    }

    private void cancelButtonHit() {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonHit() {
        int comPort;
        int tRobotId;
        try {
            String val = (String)this.robotId.getSelectedItem();
            tRobotId = new Integer(val.split(":")[0]);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "ERROR: Bluetooth Com Port must be an integer.", "Error Saving Settings", 0);
            return;
        }
        try {
            comPort = new Integer(this.blueComPort.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "ERROR: Bluetooth Com Port must be an integer.", "Error Saving Settings", 0);
            return;
        }
        if (tRobotId < 1 || tRobotId > 6) {
            JOptionPane.showMessageDialog(this, "ERROR: Robot Id must be an integer from 1 to 6.", "Error Saving Settings", 0);
            return;
        }
        int tCurrentStation = new Integer((Integer)this.currentStation.getSelectedItem());
        if (tCurrentStation < 1 || tCurrentStation > 3) {
            JOptionPane.showMessageDialog(this, "ERROR: Current Station must be an integer from 1 to 3.", "Error Saving Settings", 0);
            return;
        }
        String tStation1 = new String(this.station1Address.getText());
        String tStation2 = new String(this.station2Address.getText());
        String tStation3 = new String(this.station3Address.getText());
        if (this.checkFormat(tStation1)) {
            JOptionPane.showMessageDialog(this, "ERROR: Station 1 Address must be a proper ip address (ex: 255.255.255.255)", "Error Saving Settings", 0);
            return;
        }
        if (this.checkFormat(tStation2)) {
            JOptionPane.showMessageDialog(this, "ERROR: Station 2 Address must be a proper ip address (ex: 255.255.255.255)", "Error Saving Settings", 0);
            return;
        }
        if (this.checkFormat(tStation3)) {
            JOptionPane.showMessageDialog(this, "ERROR: Station 3 Address must be a proper ip address (ex: 255.255.255.255)", "Error Saving Settings", 0);
            return;
        }
        this.settings.robotId = tRobotId;
        this.settings.currentStation = tCurrentStation;
        this.settings.station1Address = tStation1;
        this.settings.station2Address = tStation2;
        this.settings.station3Address = tStation3;
        this.settings.fileOutputName = new String(this.outputFile.getText());
        this.settings.comPort = comPort;
        this.cancelButtonHit();
        this.settings.saveSettings("settings.ini");
    }

    private boolean checkFormat(String station) {
        String[] temp = station.split("\\.", 4);
        if (temp.length != 4) {
            return true;
        }
        try {
            int t1 = new Integer(temp[0]);
            int t2 = new Integer(temp[1]);
            int t3 = new Integer(temp[2]);
            int t4 = new Integer(temp[3]);
            return t1 < 0 || t1 > 255 || t2 < 0 || t2 > 255 || t3 < 0 || t3 > 255 || t4 < 0 || t4 > 255;
        }
        catch (Exception e) {
            return true;
        }
    }
}

