/*
 * Decompiled with CFR 0.152.
 */
package robot;

public class RobotState {
    public static final byte Idle = 0;
    public static final byte Moving = 1;
    public static final byte FindingBlock = 2;
    public static final byte DeliveringBlock = 3;
    public static final byte FindingPot = 4;
    public static final byte DeliveringPot = 4;
    public static final String[] robotStates = new String[]{"Idle", "Moving", "FindingBlock", "DeliveringBlock", "FindingPot", "DeliveringPot"};

    public static boolean isValid(byte state) {
        return state >= 0 && state < robotStates.length;
    }

    public static byte parseFrom(String data) {
        if (data == null) {
            return -1;
        }
        String temp = data.trim();
        byte i = 0;
        while (i < robotStates.length) {
            if (temp.equalsIgnoreCase(robotStates[i])) {
                return i;
            }
            i = (byte)(i + 1);
        }
        return -1;
    }

    public static String toString(byte robotState) {
        return !RobotState.isValid(robotState) ? "Invalid" : robotStates[robotState];
    }
}

