/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Dimension;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import settings.VariableSystem;
import shared.SignalDebugLevel;

public class SettingsManager {
    private VariableSystem m_settings = new VariableSystem();
    private InetAddress[] m_trackerIPAddress;
    private int m_port;
    private boolean m_autoSaveOnExit;
    private boolean m_ignorePingPongSignals;
    private boolean m_ignorePositionSignals;
    private byte m_signalDebugLevel;
    private boolean m_autoScrollConsoleWindow;
    private int m_maxConsoleHistory;
    private int m_numberOfTrackers;
    private Dimension m_webcamResolution;
    public static final String defaultSettingsFileName = "server.ini";
    public static InetAddress[] defaultTrackerIPAddress;
    public static final int defaultPort = 25500;
    public static final boolean defaultAutoSaveOnExit = true;
    public static final boolean defaultIgnorePingPongSignals = true;
    public static final boolean defaultIgnorePositionSignals = true;
    public static final byte defaultSignalDebugLevel = 3;
    public static final boolean defaultAutoScrollConsoleWindow = true;
    public static final int defaultMaxConsoleHistory = 1024;
    public static final int defaultNumberOfTrackers = 3;
    public static final Dimension defaultWebcamResolution;

    static {
        defaultWebcamResolution = new Dimension(640, 480);
    }

    public SettingsManager() {
        this.reset();
    }

    public void reset() {
        defaultTrackerIPAddress = new InetAddress[3];
        int i = 0;
        while (i < defaultTrackerIPAddress.length) {
            try {
                SettingsManager.defaultTrackerIPAddress[i] = InetAddress.getByAddress(new byte[]{-122, 117, 28, (byte)(108 + i)});
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            i = (byte)(i + 1);
        }
        this.m_port = 25500;
        this.m_autoSaveOnExit = true;
        this.m_trackerIPAddress = defaultTrackerIPAddress;
        this.m_ignorePingPongSignals = true;
        this.m_ignorePositionSignals = true;
        this.m_signalDebugLevel = (byte)3;
        this.m_autoScrollConsoleWindow = true;
        this.m_maxConsoleHistory = 1024;
        this.m_numberOfTrackers = 3;
        this.m_webcamResolution = defaultWebcamResolution;
    }

    public InetAddress getTrackerIPAddress(int trackerNumber) {
        if (trackerNumber < 1 || trackerNumber > this.m_trackerIPAddress.length) {
            return null;
        }
        return this.m_trackerIPAddress[trackerNumber - 1];
    }

    public InetAddress getDefaultTrackerIPAddress(int trackerNumber) {
        if (trackerNumber < 1 || trackerNumber > defaultTrackerIPAddress.length) {
            return null;
        }
        return defaultTrackerIPAddress[trackerNumber - 1];
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean getAutoSaveOnExit() {
        return this.m_autoSaveOnExit;
    }

    public boolean getIgnorePingPongSignals() {
        return this.m_ignorePingPongSignals;
    }

    public boolean getIgnorePositionSignals() {
        return this.m_ignorePositionSignals;
    }

    public byte getSignalDebugLevel() {
        return this.m_signalDebugLevel;
    }

    public boolean getAutoScrollConsoleWindow() {
        return this.m_autoScrollConsoleWindow;
    }

    public int getMaxConsoleHistory() {
        return this.m_maxConsoleHistory;
    }

    public int getNumberOfTrackers() {
        return this.m_numberOfTrackers;
    }

    public Dimension getWebcamResolution() {
        return this.m_webcamResolution;
    }

    public boolean setTrackerIPAddress(int trackerNumber, String hostAddress) {
        if (hostAddress == null || trackerNumber < 1 || trackerNumber > this.m_trackerIPAddress.length) {
            return false;
        }
        try {
            this.m_trackerIPAddress[trackerNumber - 1] = InetAddress.getByName(hostAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return true;
    }

    public void setAutoSaveOnExit(boolean autoSave) {
        this.m_autoSaveOnExit = autoSave;
    }

    public boolean setAutoSaveOnExit(String data) {
        if (data == null) {
            return false;
        }
        String value = data.trim();
        if (value.equalsIgnoreCase("true")) {
            this.m_autoSaveOnExit = true;
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            this.m_autoSaveOnExit = false;
            return true;
        }
        return false;
    }

    public void setPort(int port) {
        if (port >= 0 && port <= 65355) {
            this.m_port = port;
        }
    }

    public void setIgnorePingPongSignals(boolean ignorePingPongSignals) {
        this.m_ignorePingPongSignals = ignorePingPongSignals;
    }

    public boolean setIgnorePingPongSignals(String data) {
        if (data == null) {
            return false;
        }
        String value = data.trim();
        if (value.equalsIgnoreCase("true")) {
            this.m_ignorePingPongSignals = true;
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            this.m_ignorePingPongSignals = false;
            return true;
        }
        return false;
    }

    public void setIgnorePositionSignals(boolean ignorePositionSignals) {
        this.m_ignorePositionSignals = ignorePositionSignals;
    }

    public boolean setIgnorePositionSignals(String data) {
        if (data == null) {
            return false;
        }
        String value = data.trim();
        if (value.equalsIgnoreCase("true")) {
            this.m_ignorePositionSignals = true;
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            this.m_ignorePositionSignals = false;
            return true;
        }
        return false;
    }

    public void setSignalDebugLevel(byte signalDebugLevel) {
        if (SignalDebugLevel.isValid(signalDebugLevel)) {
            this.m_signalDebugLevel = signalDebugLevel;
        }
    }

    public void setAutoScrollConsoleWindow(boolean autoScroll) {
        this.m_autoScrollConsoleWindow = autoScroll;
    }

    public boolean setAutoScrollConsoleWindow(String data) {
        if (data == null) {
            return false;
        }
        String value = data.trim();
        if (value.equalsIgnoreCase("true")) {
            this.m_autoScrollConsoleWindow = true;
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            this.m_autoScrollConsoleWindow = false;
            return true;
        }
        return false;
    }

    public void setMaxConsoleHistory(int maxConsoleHistory) {
        this.m_maxConsoleHistory = maxConsoleHistory;
    }

    public boolean setNumberOfTrackers(int numberOfTrackers) {
        if (numberOfTrackers < 1) {
            return false;
        }
        this.m_numberOfTrackers = numberOfTrackers;
        return true;
    }

    public boolean setWebcamResolution(int x, int y) {
        return this.setWebcamResolution(new Dimension(x, y));
    }

    public boolean setWebcamResolution(Dimension resolution) {
        if (resolution == null) {
            return false;
        }
        if (resolution.width < 16 || resolution.height < 16 || resolution.height > 4096 || resolution.width > 4096) {
            return false;
        }
        this.m_webcamResolution = resolution;
        return true;
    }

    public boolean setWebcamResolution(String data) {
        int y;
        int x;
        if (data == null) {
            return false;
        }
        String value = data.trim();
        if (value == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",x ", false);
        if (st.countTokens() != 2) {
            return false;
        }
        try {
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (x < 16 || y < 16 || x > 4096 || y > 4096) {
            return false;
        }
        this.m_webcamResolution = new Dimension(x, y);
        return true;
    }

    public boolean load() {
        return this.loadFrom(defaultSettingsFileName);
    }

    public boolean save() {
        return this.saveTo(defaultSettingsFileName);
    }

    public boolean loadFrom(String fileName) {
        VariableSystem variables = VariableSystem.readFrom(fileName);
        if (variables == null) {
            System.out.println("ERROR: Unable to load settings file: \"" + fileName + "\".");
            return false;
        }
        this.m_settings = variables;
        int i = 0;
        while (i < this.m_trackerIPAddress.length) {
            this.setTrackerIPAddress(i + 1, this.m_settings.getValue("Robot Tracker " + (i + 1) + " IP", "Settings"));
            ++i;
        }
        try {
            this.setPort(Integer.parseInt(this.m_settings.getValue("Port", "Settings")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setAutoSaveOnExit(this.m_settings.getValue("Autosave on Exit", "Settings"));
        this.setIgnorePingPongSignals(this.m_settings.getValue("Ignore Ping Pong Signals", "Settings"));
        this.setIgnorePositionSignals(this.m_settings.getValue("Ignore Position Signals", "Settings"));
        this.setSignalDebugLevel(SignalDebugLevel.parseFrom(this.m_settings.getValue("Signal Debug Level", "Settings")));
        this.setAutoScrollConsoleWindow(this.m_settings.getValue("Auto-scroll Console Window", "Settings"));
        try {
            this.setMaxConsoleHistory(Integer.parseInt(this.m_settings.getValue("Max Console History", "Settings")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.setNumberOfTrackers(Integer.parseInt(this.m_settings.getValue("Number of Trackers", "Settings")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setWebcamResolution(this.m_settings.getValue("Webcam Resolution", "Settings"));
        return true;
    }

    public boolean saveTo(String fileName) {
        int i = 0;
        while (i < this.m_trackerIPAddress.length) {
            this.m_settings.setValue("Robot Tracker " + (i + 1) + " IP Address", this.m_trackerIPAddress[i].getHostAddress(), "Settings");
            ++i;
        }
        this.m_settings.setValue("Port", this.m_port, "Settings");
        this.m_settings.setValue("Autosave on Exit", this.m_autoSaveOnExit, "Settings");
        this.m_settings.setValue("Ignore Ping Pong Signals", this.m_ignorePingPongSignals, "Settings");
        this.m_settings.setValue("Ignore Position Signals", this.m_ignorePositionSignals, "Settings");
        this.m_settings.setValue("Signal Debug Level", SignalDebugLevel.toString(this.m_signalDebugLevel), "Settings");
        this.m_settings.setValue("Auto-scroll Console Window", this.m_autoScrollConsoleWindow, "Settings");
        this.m_settings.setValue("Max Console History", this.m_maxConsoleHistory, "Settings");
        this.m_settings.setValue("Number of Trackers", this.m_numberOfTrackers, "Settings");
        this.m_settings.setValue("Webcam Resolution", String.valueOf(this.m_webcamResolution.width) + ", " + this.m_webcamResolution.height, "Settings");
        this.m_settings.sort();
        return this.m_settings.writeTo(fileName);
    }
}

