/*
 * Decompiled with CFR 0.152.
 */
package shared;

import shared.Updatable;

public class AutomaticUpdater
extends Thread {
    private long m_interval;
    private Updatable m_updatable;

    public AutomaticUpdater(long interval) {
        this.m_interval = interval < 5L ? 50L : interval;
    }

    public void initialize() {
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public void setTarget(Updatable updatable) {
        this.m_updatable = updatable;
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    @Override
    public void run() {
        while (true) {
            if (this.m_updatable != null) {
                this.m_updatable.update();
            }
            try {
                AutomaticUpdater.sleep(this.m_interval);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

